#ifndef Ramo_
#define Ramo_

template<class TV,class TR>
class ListAdjGrafo;

template<class TV,class TR>
class Vertice;

template<class TV,class TR>   //Class representativa dos ramos que ligam vertices do grafo
class Ramo
{
	friend class ListAdjGrafo<TV,TR>;
	
	private:
		TR rconteudo;
		Vertice<TV,TR>* apv;
		Ramo<TV,TR>* apr;
	
	public:
		Ramo();
		Ramo(const TR& rcont, Vertice<TV,TR>* pv);
		Ramo(const Ramo<TV,TR>& r);
		~Ramo();
};

template<class TV,class TR>
Ramo<TV,TR>::Ramo()
{
	apv=NULL;
	apr=NULL;
}

template<class TV,class TR>
Ramo<TV,TR>::Ramo(const TR& rcont, Vertice<TV,TR>* pv)
{
	rconteudo=rcont;
	apv=pv;
	apr=NULL;
}

template<class TV,class TR>
Ramo<TV,TR>::Ramo(const Ramo<TV,TR>& r)
{
	rconteudo=r.rconteudo;
	apv=r.apv;
	apr=r.apr;
}

template<class TV,class TR>
Ramo<TV,TR>::~Ramo()
{

}

#endif
