/*
 *  derivada.cpp
 *  teste_heranca
 *
 *  Created by António Barros on 2008/10/22.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#include "derivada.h"

#include <iostream>

using namespace std;

// Construtor vazio, chama o contrutor vazio da classe Base.
Derivada::Derivada() : Base() {
	valor = 0;
}

// Construtor com parâmetros, chama o construtor com parâmetros
// da classe Base, passando-lhe os respectivos argumentos.
// SUGESTÃO: alterar para chamar o construtor vazio da classe Base.
Derivada::Derivada(int a, int b, const string& n) : Base(a, n) {
	valor = b;
}

// Construtor cópia, chama o construtor cópia da classe Base.
// Note como a referência do objecto 'd' é passada para o construtor de Base.
// SUGESTÃO: alterar para chamar o construtor vazio da classe Base.
Derivada::Derivada(const Derivada& d) : Base(d) {
	valor = d.valor;
}

Derivada::~Derivada() {
}

// Este método chama o método mostra() da classe Base para poupar trabalho,
// aproveitando a funcionalidade já definida na classe Base.
void Derivada::mostra() {
	Base::mostra();
	cout << "[DERIVADA]: " << valor << endl;
}