#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <syslog.h>
#include <time.h>

/* seconds to wait before restarting */
#define DELAY 30

/* if server runs for less than this seconds add DELAY_ADD before restart */
#define ERROR_DELAY 60

/* delay increment if the server runs for less than ERROR_DELAY */
#define DELAY_ADD 15 

int main(int argc, char **argv)
{
int i=0, delay=DELAY;
time_t lastStart, now;
char *srv, *a;
openlog("ALWAYS",0,LOG_DAEMON);
if(argc==1)
	{ 
	syslog(LOG_DAEMON|LOG_ALERT,
		"usage: %s command [args]",argv[0]);
	closelog();
	exit(1);
	}
srv=a=argv[1];
while(*a)
	{
	if(*a=='/') srv=a+1;
	a++;
	}

syslog(LOG_DAEMON|LOG_INFO,"starting %s",srv);

while(1)
	{
	if(!fork()) 
		{
		execvp(argv[1],&argv[1]);
		syslog(LOG_DAEMON|LOG_ALERT,
			"failed to start %s",argv[1]);
		closelog();
		exit(1); 
		}
	lastStart=time(NULL);
	if(wait(&i)<0)
		{
		syslog(LOG_DAEMON|LOG_ALERT,
			"WAIT error on %s",srv);
		closelog();
		exit(1);
		}
	now=time(NULL);
	if(now-lastStart>ERROR_DELAY) delay=DELAY;
	else delay=delay+DELAY_ADD;
	syslog(LOG_DAEMON|LOG_ERR,
		"%s ended with exit code %i",srv,WEXITSTATUS(i));
	syslog(LOG_DAEMON|LOG_ERR,
		"restarting %s in %i seconds",srv,delay);
	sleep(delay);
	}
}
