/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderChildrenPair;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderOrder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FolderChildren
extends Children.Keys<FolderChildrenPair>
implements PropertyChangeListener,
ChangeListener,
FileChangeListener {
    private static RequestProcessor refRP = new RequestProcessor("FolderChildren_Refresh");
    private FolderList folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private FileChangeListener fcListener;
    private ChangeListener changeListener;
    private Logger err;
    private volatile Task refTask = Task.EMPTY;

    public FolderChildren(DataFolder dataFolder) {
        this(dataFolder, DataFilter.ALL);
    }

    public FolderChildren(DataFolder dataFolder, DataFilter dataFilter) {
        super(true);
        this.folder = FolderList.find(dataFolder.getPrimaryFile(), true);
        this.filter = dataFilter;
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        this.fcListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.folder.getPrimaryFile());
        String string = dataFolder.getPrimaryFile().isRoot() ? "org.openide.loaders.FolderChildren" : "org.openide.loaders.FolderChildren." + dataFolder.getPrimaryFile().getPath().replace('/', '.');
        this.err = Logger.getLogger(string);
    }

    DataFilter getFilter() {
        return this.filter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.err.log(Level.FINE, "Got a change {0}", propertyChangeEvent.getPropertyName());
        this.refreshChildren(0);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.refreshChildren(1);
    }

    final void refreshChildren(int n) {
        class R
        implements Runnable {
            int op;

            R() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block7: {
                    block6: {
                        if (this.op == 1) {
                            this.op = 2;
                            Children.MUTEX.postWriteRequest((Runnable)this);
                            return;
                        }
                        FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}", this.op);
                        try {
                            if (this.op == -1) {
                                FolderChildren.this.setKeys(Collections.emptyList());
                                Object var7_1 = null;
                                FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", this.op);
                                return;
                            }
                            FileObject[] fileObjectArray = FolderChildren.this.folder.getPrimaryFile().getChildren();
                            FolderOrder folderOrder = FolderOrder.findFor(FolderChildren.this.folder.getPrimaryFile());
                            Arrays.sort(fileObjectArray, folderOrder);
                            ArrayList<FolderChildrenPair> arrayList = new ArrayList<FolderChildrenPair>(fileObjectArray.length);
                            for (FileObject fileObject : FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false)) {
                                arrayList.add(new FolderChildrenPair(fileObject));
                            }
                            if (this.op == 2) {
                                FolderChildren.this.setKeys(Collections.emptyList());
                                FolderChildren.this.setKeys(arrayList);
                                break block6;
                            }
                            if (this.op != 0) throw new IllegalStateException("Unknown op: " + this.op);
                            FolderChildren.this.setKeys(arrayList);
                            break block7;
                        }
                        catch (Throwable throwable) {
                            Object var7_4 = null;
                            FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", this.op);
                            throw throwable;
                        }
                    }
                    Object var7_2 = null;
                    FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", this.op);
                    return;
                }
                Object var7_3 = null;
                FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", this.op);
            }
        }
        R r = new R();
        if (n == 10) {
            this.refTask.waitFinished();
            r.op = 0;
            r.run();
        } else {
            r.op = n;
            this.refTask = refRP.post((Runnable)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Node[] createNodes(FolderChildrenPair folderChildrenPair) {
        Node node;
        block8: {
            long l = System.currentTimeMillis();
            node = null;
            try {
                block7: {
                    try {
                        FileObject fileObject = folderChildrenPair.primaryFile;
                        DataObject dataObject = DataObject.find(fileObject);
                        if (!fileObject.equals(dataObject.getPrimaryFile()) || this.filter != null && !this.filter.acceptDataObject(dataObject)) break block7;
                        node = dataObject.getClonedNodeDelegate(this.filter);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Logger.getLogger(FolderChildren.class.getName()).log(Level.FINE, null, dataObjectNotFoundException);
                        Object var8_8 = null;
                        long l4 = System.currentTimeMillis() - l;
                        if (this.err.isLoggable(Level.FINE)) {
                            this.err.fine("createNodes: " + folderChildrenPair + " took: " + l4 + " ms");
                            this.err.fine("  returning: " + node);
                        }
                        break block8;
                    }
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                long l2 = System.currentTimeMillis() - l;
                if (!this.err.isLoggable(Level.FINE)) throw throwable;
                this.err.fine("createNodes: " + folderChildrenPair + " took: " + l2 + " ms");
                this.err.fine("  returning: " + node);
                throw throwable;
            }
            long l3 = System.currentTimeMillis() - l;
            if (this.err.isLoggable(Level.FINE)) {
                this.err.fine("createNodes: " + folderChildrenPair + " took: " + l3 + " ms");
                this.err.fine("  returning: " + node);
            }
        }
        if (node == null) {
            return null;
        }
        Node[] nodeArray = new Node[1];
        Node[] nodeArray2 = nodeArray;
        nodeArray[0] = node;
        return nodeArray2;
    }

    public Node[] getNodes(boolean bl) {
        if (bl) {
            this.waitOptimalResult();
        }
        return this.getNodes();
    }

    public Node findChild(String string) {
        if (FolderChildren.checkChildrenMutex()) {
            this.getNodesCount(true);
        }
        return super.findChild(string);
    }

    private void waitOptimalResult() {
        if (FolderChildren.checkChildrenMutex()) {
            this.err.fine("waitOptimalResult");
            this.folder.waitProcessingFinished();
            this.refTask.waitFinished();
            this.err.fine("waitOptimalResult: waitProcessingFinished");
        } else {
            Logger.getLogger(FolderChildren.class.getName()).log(Level.WARNING, null, new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
        }
    }

    public int getNodesCount(boolean bl) {
        if (bl) {
            this.waitOptimalResult();
        }
        return this.getNodesCount();
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        this.err.fine("addNotify begin");
        this.folder.addPropertyChangeListener(this.listener);
        this.folder.getPrimaryFile().addFileChangeListener(this.fcListener);
        if (this.filter instanceof ChangeableDataFilter) {
            ChangeableDataFilter changeableDataFilter = (ChangeableDataFilter)this.filter;
            this.changeListener = WeakListeners.change((ChangeListener)this, (Object)changeableDataFilter);
            changeableDataFilter.addChangeListener(this.changeListener);
        }
        this.refreshChildren(10);
        this.err.fine("addNotify end");
    }

    protected void removeNotify() {
        this.err.fine("removeNotify begin");
        this.folder.getPrimaryFile().removeFileChangeListener(this.fcListener);
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        List list = Collections.emptyList();
        this.setKeys(list);
        this.err.fine("removeNotify end");
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        if ("NetBeansAttrAssignedLoader".equals(fileAttributeEvent.getName())) {
            DataObjectPool.checkAttributeChanged(fileAttributeEvent);
            this.refreshKey(new FolderChildrenPair(fileAttributeEvent.getFile()));
            this.refreshChildren(10);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.refreshChildren(0);
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.refreshChildren(0);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.refreshChildren(0);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.refreshChildren(0);
    }
}

