/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.Color;
import org.netbeans.lib.profiler.ui.charts.AbstractSynchronousXYChartModel;

public class DynamicSynchronousXYChartModel
extends AbstractSynchronousXYChartModel {
    protected long[] maxYValues;
    protected long[] minYValues;
    protected Color[] seriesColors;
    protected String[] seriesNames;
    protected long[] xValues;
    protected long[][] yValues;
    protected int itemCount = 0;
    protected int seriesCount = 0;
    protected long maxXValue = 0L;
    protected long minXValue = 0L;
    private int arrayBufferSize = 100;
    private int currentArraySize;

    public void setArrayBufferSize(int n) {
        this.arrayBufferSize = n;
        this.checkArraySize();
    }

    public int getArrayBufferSize() {
        return this.arrayBufferSize;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public long getMaxDisplayYValue(int n) {
        return this.getMaxYValue(n);
    }

    public long getMaxXValue() {
        return this.maxXValue;
    }

    public long getMaxYValue(int n) {
        return this.maxYValues[n];
    }

    public long getMinDisplayYValue(int n) {
        return 0L;
    }

    public long getMinXValue() {
        return this.minXValue;
    }

    public long getMinYValue(int n) {
        return this.minYValues[n];
    }

    public Color getSeriesColor(int n) {
        return this.seriesColors[n];
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public String getSeriesName(int n) {
        return this.seriesNames[n];
    }

    public long getXValue(int n) {
        return this.xValues[n];
    }

    public long getYValue(int n, int n2) {
        return this.yValues[n][n2];
    }

    public void addItemValues(long l, long[] lArray) {
        this.checkArraySize();
        if (this.itemCount == 0) {
            this.minXValue = l;
            this.maxXValue = l;
            for (int i = 0; i < this.seriesCount; ++i) {
                this.minYValues[i] = lArray[i];
                this.maxYValues[i] = lArray[i];
            }
        } else {
            if (this.xValues[this.itemCount - 1] >= l) {
                throw new RuntimeException("New x-value not greater than previous x-value.");
            }
            this.maxXValue = l;
            for (int i = 0; i < this.seriesCount; ++i) {
                this.minYValues[i] = Math.min(this.minYValues[i], lArray[i]);
                this.maxYValues[i] = Math.max(this.maxYValues[i], lArray[i]);
            }
        }
        this.xValues[this.itemCount] = l;
        this.yValues[this.itemCount] = lArray;
        ++this.itemCount;
        this.fireChartDataChanged();
    }

    public void setupModel(String[] stringArray, Color[] colorArray) {
        this.seriesNames = stringArray;
        this.seriesColors = colorArray;
        if (stringArray.length != colorArray.length) {
            this.seriesCount = 0;
            throw new RuntimeException("Counts of series names and series colors don't match.");
        }
        this.seriesCount = stringArray.length;
        this.itemCount = 0;
        this.currentArraySize = this.arrayBufferSize;
        this.xValues = new long[this.arrayBufferSize];
        this.yValues = new long[this.arrayBufferSize][];
        this.minXValue = 0L;
        this.maxXValue = 0L;
        this.minYValues = new long[this.seriesCount];
        this.maxYValues = new long[this.seriesCount];
    }

    private void checkArraySize() {
        if (this.currentArraySize == this.itemCount) {
            this.xValues = DynamicSynchronousXYChartModel.extendArray(this.xValues, this.arrayBufferSize);
            this.yValues = DynamicSynchronousXYChartModel.extendArray(this.yValues, this.arrayBufferSize);
            this.minYValues = DynamicSynchronousXYChartModel.extendArray(this.minYValues, this.arrayBufferSize);
            this.maxYValues = DynamicSynchronousXYChartModel.extendArray(this.maxYValues, this.arrayBufferSize);
            this.currentArraySize += this.arrayBufferSize;
        }
    }

    private static long[] extendArray(long[] lArray, int n) {
        int n2 = lArray.length;
        long[] lArray2 = new long[n2 + n];
        System.arraycopy(lArray, 0, lArray2, 0, n2);
        return lArray2;
    }

    private static long[][] extendArray(long[][] lArray, int n) {
        int n2 = lArray.length;
        long[][] lArrayArray = new long[n2 + n][];
        System.arraycopy(lArray, 0, lArrayArray, 0, n2);
        return lArrayArray;
    }
}

