/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModelDataResetListener;

public class MemoryGraphPanel
extends GraphPanel
implements ChartModelListener,
VMTelemetryXYChartModelDataResetListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.graphs.Bundle");
    private static final String TOTAL_MEMORY_CURRENT_STRING = messages.getString("MemoryGraphPanel_TotalMemoryCurrentString");
    private static final String USED_MEMORY_CURRENT_STRING = messages.getString("MemoryGraphPanel_UsedMemoryCurrentString");
    private static final String USED_MEMORY_MAXIMUM_STRING = messages.getString("MemoryGraphPanel_UsedMemoryMaximumString");
    private static final String TIME_AT_CURSOR_STRING = messages.getString("MemoryGraphPanel_TimeAtCursorString");
    private static final String TOTAL_MEMORY_AT_CURSOR_STRING = messages.getString("MemoryGraphPanel_TotalMemoryAtCursorString");
    private static final String USED_MEMORY_AT_CURSOR_STRING = messages.getString("MemoryGraphPanel_UsedMemoryAtCursorString");
    private static final String CHART_ACCESS_NAME = messages.getString("MemoryGraphPanel_ChartAccessName");
    private JPanel bigLegendPanel;
    private JPanel smallLegendPanel;
    private SynchronousXYChart xyChart;
    private VMTelemetryXYChartModel memoryXYChartModel;
    private boolean completeFunctionality;
    private int chartTimeLength = 180000;

    public MemoryGraphPanel(VMTelemetryXYChartModel vMTelemetryXYChartModel, Action action) {
        this(false, null, vMTelemetryXYChartModel, action);
    }

    public MemoryGraphPanel(boolean bl, Color color, VMTelemetryXYChartModel vMTelemetryXYChartModel, final Action action) {
        this.completeFunctionality = bl;
        this.memoryXYChartModel = vMTelemetryXYChartModel;
        vMTelemetryXYChartModel.addDataResetListener(this);
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(vMTelemetryXYChartModel.getSeriesName(0), new ColorIcon(vMTelemetryXYChartModel.getSeriesColor(0), Color.BLACK, 18, 9), 10);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JLabel jLabel2 = new JLabel(vMTelemetryXYChartModel.getSeriesName(1), new ColorIcon(vMTelemetryXYChartModel.getSeriesColor(1), Color.BLACK, 18, 9), 10);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.bigLegendPanel = new JPanel();
        this.bigLegendPanel.add(jLabel);
        this.bigLegendPanel.add(jLabel2);
        JLabel jLabel3 = new JLabel(vMTelemetryXYChartModel.getSeriesName(0), new ColorIcon(vMTelemetryXYChartModel.getSeriesColor(0), null, 8, 8), 10);
        jLabel3.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
        jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JLabel jLabel4 = new JLabel(vMTelemetryXYChartModel.getSeriesName(1), new ColorIcon(vMTelemetryXYChartModel.getSeriesColor(1), null, 8, 8), 10);
        jLabel4.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
        jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.smallLegendPanel = new JPanel();
        this.smallLegendPanel.setLayout(new FlowLayout(1, 0, 1));
        this.smallLegendPanel.setBackground(Color.WHITE);
        this.smallLegendPanel.setBorder(new LineBorder(new Color(235, 235, 235), 1));
        this.smallLegendPanel.add(jLabel3);
        this.smallLegendPanel.add(jLabel4);
        this.xyChart = new SynchronousXYChart(2, 50, 0.01){

            public String getToolTipText(MouseEvent mouseEvent) {
                return MemoryGraphPanel.this.getChartToolTipText(mouseEvent);
            }

            public Point getToolTipLocation(MouseEvent mouseEvent) {
                return new Point(mouseEvent.getX(), mouseEvent.getY() + 20);
            }
        };
        if (bl) {
            this.xyChart.setTopChartMargin(50);
            this.xyChart.allowSelection();
            this.xyChart.setMinimumVerticalMarksDistance(50);
        } else {
            this.xyChart.setTopChartMargin(20);
            this.xyChart.denySelection();
            this.xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
        }
        this.xyChart.setVerticalAxisValueDivider(0x100000);
        this.xyChart.setVerticalAxisValueString("M");
        long l = System.currentTimeMillis();
        this.xyChart.setupInitialAppearance(l, l + 1200L, 0L, 2L);
        this.getAccessibleContext().setAccessibleName(CHART_ACCESS_NAME);
        this.xyChart.setAccessibleContext(this.getAccessibleContext());
        this.chartDataReset();
        if (color != null) {
            this.setOpaque(true);
            this.setBackground(color);
            this.xyChart.setBackgroundPaint(color);
        }
        this.xyChart.setModel(vMTelemetryXYChartModel);
        if (!bl) {
            vMTelemetryXYChartModel.addChartModelListener(this);
        }
        this.add(this.xyChart);
        this.xyChart.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2 && action != null) {
                    action.actionPerformed(null);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.xyChart);
    }

    public JPanel getBigLegendPanel() {
        return this.bigLegendPanel;
    }

    public SynchronousXYChart getChart() {
        return this.xyChart;
    }

    public String getChartToolTipText(MouseEvent mouseEvent) {
        if (this.memoryXYChartModel.getItemCount() < 2) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        if (!this.completeFunctionality || !this.xyChart.hasValidDataForPosition(mouseEvent.getX(), mouseEvent.getY())) {
            MemoryGraphPanel.appendToolTipItem(stringBuffer, TOTAL_MEMORY_CURRENT_STRING, this.intFormat.format(this.memoryXYChartModel.getYValue(this.memoryXYChartModel.getItemCount() - 1, 0)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(stringBuffer, USED_MEMORY_CURRENT_STRING, this.intFormat.format(this.memoryXYChartModel.getYValue(this.memoryXYChartModel.getItemCount() - 1, 1)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(stringBuffer, USED_MEMORY_MAXIMUM_STRING, this.intFormat.format(this.memoryXYChartModel.getMaxYValue(1)) + " B", true);
        } else {
            MemoryGraphPanel.appendToolTipItem(stringBuffer, TOTAL_MEMORY_CURRENT_STRING, this.intFormat.format(this.memoryXYChartModel.getYValue(this.memoryXYChartModel.getItemCount() - 1, 0)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(stringBuffer, USED_MEMORY_CURRENT_STRING, this.intFormat.format(this.memoryXYChartModel.getYValue(this.memoryXYChartModel.getItemCount() - 1, 1)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(stringBuffer, USED_MEMORY_MAXIMUM_STRING, this.intFormat.format(this.memoryXYChartModel.getMaxYValue(1)) + " B", false);
            stringBuffer.append("<br>");
            MemoryGraphPanel.appendToolTipItem(stringBuffer, TIME_AT_CURSOR_STRING, this.xyChart.getTimeAtPosition(mouseEvent.getX()), false);
            MemoryGraphPanel.appendToolTipItem(stringBuffer, TOTAL_MEMORY_AT_CURSOR_STRING, this.intFormat.format(this.xyChart.getYValueAtPosition(mouseEvent.getX(), 0)) + " B", false);
            MemoryGraphPanel.appendToolTipItem(stringBuffer, USED_MEMORY_AT_CURSOR_STRING, this.intFormat.format(this.xyChart.getYValueAtPosition(mouseEvent.getX(), 1)) + " B", true);
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    public JPanel getSmallLegendPanel() {
        return this.smallLegendPanel;
    }

    public void chartDataChanged() {
        if (!this.completeFunctionality && this.xyChart.isFitToWindow() && this.memoryXYChartModel.getMaxXValue() - this.memoryXYChartModel.getMinXValue() >= (long)this.chartTimeLength) {
            UIUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    MemoryGraphPanel.this.xyChart.setTrackingEnd();
                }
            });
        }
    }

    public void chartDataReset() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                MemoryGraphPanel.this.xyChart.resetChart();
                if (MemoryGraphPanel.this.completeFunctionality) {
                    MemoryGraphPanel.this.xyChart.resetTrackingEnd();
                    MemoryGraphPanel.this.xyChart.resetFitToWindow();
                } else {
                    MemoryGraphPanel.this.xyChart.setFitToWindow();
                }
            }
        });
    }

    private static void appendToolTipItem(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        stringBuffer.append("&nbsp;<b>");
        stringBuffer.append(string);
        stringBuffer.append("</b>: ");
        stringBuffer.append(string2);
        stringBuffer.append("&nbsp;");
        if (!bl) {
            stringBuffer.append("<br>");
        }
    }
}

