/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;

public abstract class MemoryResultsSnapshot
extends ResultsSnapshot {
    private JMethodIdTable table;
    private String[] classNames;
    private long[] objectsSizePerClass;
    private RuntimeMemoryCCTNode[] stacksForClasses;
    private int nProfiledClasses;

    public MemoryResultsSnapshot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryResultsSnapshot(long l, long l2, MemoryCCTProvider memoryCCTProvider, ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        super(l, l2);
        ProfilingSessionStatus profilingSessionStatus = profilerClient.getStatus();
        profilingSessionStatus.beginTrans(false);
        try {
            this.performInit(profilerClient, memoryCCTProvider);
            this.nProfiledClasses = memoryCCTProvider.getNProfiledClasses();
            int n = 0;
            if (memoryCCTProvider.getObjectsSizePerClass() != null) {
                n = memoryCCTProvider.getObjectsSizePerClass().length;
                this.objectsSizePerClass = new long[n];
                System.arraycopy(memoryCCTProvider.getObjectsSizePerClass(), 0, this.objectsSizePerClass, 0, n);
            }
            String[] stringArray = profilingSessionStatus.getClassNames();
            n = this.nProfiledClasses;
            this.classNames = new String[n];
            System.arraycopy(stringArray, 0, this.classNames, 0, n);
            if (memoryCCTProvider.getStacksForClasses() != null && this.checkContainsStacks(memoryCCTProvider.getStacksForClasses())) {
                this.stacksForClasses = new RuntimeMemoryCCTNode[memoryCCTProvider.getStacksForClasses().length];
                HashSet hashSet = new HashSet(10000);
                for (int i = 0; i < this.stacksForClasses.length; ++i) {
                    if (memoryCCTProvider.getStacksForClasses()[i] == null) continue;
                    this.stacksForClasses[i] = (RuntimeMemoryCCTNode)memoryCCTProvider.getStacksForClasses()[i].clone();
                    this.stacksForClasses[i].addAllJMethodIds(hashSet);
                }
                Integer[] integerArray = new Integer[hashSet.size()];
                hashSet.toArray(integerArray);
                int[] nArray = new int[hashSet.size()];
                for (int i = 0; i < integerArray.length; ++i) {
                    nArray[i] = integerArray[i];
                }
                String[][] stringArray2 = profilerClient.getMethodNamesForJMethodIds(nArray);
                this.table = new JMethodIdTable(nArray, stringArray2);
            }
        }
        finally {
            profilingSessionStatus.endTrans();
            if (LOGGER.isLoggable(Level.FINEST)) {
                this.debugValues();
            }
        }
    }

    public String getClassName(int n) {
        return this.classNames[n];
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public JMethodIdTable getJMethodIdTable() {
        return this.table;
    }

    public int getNProfiledClasses() {
        return this.nProfiledClasses;
    }

    public long[] getObjectsSizePerClass() {
        return this.objectsSizePerClass;
    }

    public boolean containsStacks() {
        return this.stacksForClasses != null;
    }

    public PresoObjAllocCCTNode createPresentationCCT(int n, boolean bl) {
        if (this.stacksForClasses == null) {
            return null;
        }
        RuntimeMemoryCCTNode runtimeMemoryCCTNode = this.stacksForClasses[n];
        if (runtimeMemoryCCTNode == null) {
            return null;
        }
        return this.createPresentationCCT(runtimeMemoryCCTNode, n, bl);
    }

    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n;
        super.readFromStream(dataInputStream);
        this.nProfiledClasses = dataInputStream.readInt();
        this.classNames = new String[this.nProfiledClasses];
        this.objectsSizePerClass = new long[this.nProfiledClasses];
        for (n = 0; n < this.nProfiledClasses; ++n) {
            this.classNames[n] = dataInputStream.readUTF();
            this.objectsSizePerClass[n] = dataInputStream.readLong();
        }
        if (dataInputStream.readBoolean()) {
            n = dataInputStream.readInt();
            this.stacksForClasses = new RuntimeMemoryCCTNode[n];
            for (int i = 0; i < n; ++i) {
                int n2 = dataInputStream.readInt();
                if (n2 == 0) continue;
                this.stacksForClasses[i] = RuntimeMemoryCCTNode.create(n2);
                this.stacksForClasses[i].readFromStream(dataInputStream);
            }
            if (dataInputStream.readBoolean()) {
                this.table = new JMethodIdTable();
                this.table.readFromStream(dataInputStream);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        int n;
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeInt(this.nProfiledClasses);
        for (n = 0; n < this.nProfiledClasses; ++n) {
            dataOutputStream.writeUTF(this.classNames[n]);
            dataOutputStream.writeLong(this.objectsSizePerClass[n]);
        }
        dataOutputStream.writeBoolean(this.stacksForClasses != null);
        if (this.stacksForClasses != null) {
            dataOutputStream.writeInt(this.stacksForClasses.length);
            for (n = 0; n < this.stacksForClasses.length; ++n) {
                if (this.stacksForClasses[n] == null) {
                    dataOutputStream.writeInt(0);
                    continue;
                }
                dataOutputStream.writeInt(this.stacksForClasses[n].getType());
                this.stacksForClasses[n].writeToStream(dataOutputStream);
            }
            dataOutputStream.writeBoolean(this.table != null);
            if (this.table != null) {
                this.table.writeToStream(dataOutputStream);
            }
        }
    }

    protected abstract PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode var1, int var2, boolean var3);

    protected abstract void performInit(ProfilerClient var1, MemoryCCTProvider var2) throws ClientUtils.TargetAppOrVMTerminated;

    private boolean checkContainsStacks(RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray) {
        for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
            RuntimeMemoryCCTNode runtimeMemoryCCTNode = runtimeMemoryCCTNodeArray[i];
            if (runtimeMemoryCCTNode == null || runtimeMemoryCCTNode instanceof RuntimeObjAllocTermCCTNode || runtimeMemoryCCTNode instanceof RuntimeObjLivenessTermCCTNode) continue;
            return true;
        }
        return false;
    }

    void debugValues() {
        LOGGER.finest("nProfiledClasses: " + this.nProfiledClasses);
        LOGGER.finest("stacksForClasses.length: " + this.debugLength(this.stacksForClasses));
        LOGGER.finest("objectsSizePerClass.length: " + this.debugLength(this.objectsSizePerClass));
        LOGGER.finest("classNames.length: " + this.debugLength(this.classNames));
        LOGGER.finest("table: " + (this.table == null ? "null" : this.table.debug()));
    }
}

