/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public class PresoObjAllocCCTNode
implements CCTNode {
    public static final String VM_ALLOC_CLASS = "org.netbeans.lib.profiler.server.ProfilerRuntimeMemory";
    public static final String VM_ALLOC_METHOD = "traceVMObjectAlloc";
    private static final String VM_ALLOC_TEXT = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("PresoObjAllocCCTNode_VMAllocMsg");
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_ALLOC_OBJ_SIZE = 2;
    public static final int SORT_BY_ALLOC_OBJ_NUMBER = 3;
    public long nCalls;
    public long totalObjSize;
    PresoObjAllocCCTNode parent;
    String className;
    String methodName;
    String methodSig;
    String nodeName;
    PresoObjAllocCCTNode[] children;
    int methodId;

    protected PresoObjAllocCCTNode(RuntimeMemoryCCTNode runtimeMemoryCCTNode) {
        this.methodId = runtimeMemoryCCTNode.methodId;
        if (runtimeMemoryCCTNode instanceof RuntimeObjAllocTermCCTNode) {
            RuntimeObjAllocTermCCTNode runtimeObjAllocTermCCTNode = (RuntimeObjAllocTermCCTNode)runtimeMemoryCCTNode;
            this.nCalls += runtimeObjAllocTermCCTNode.nCalls;
            this.totalObjSize += runtimeObjAllocTermCCTNode.totalObjSize;
        }
    }

    public static void getNamesForMethodIdsFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray) throws ClientUtils.TargetAppOrVMTerminated {
        if (runtimeMemoryCCTNodeArray == null) {
            return;
        }
        for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
            if (runtimeMemoryCCTNodeArray[i] == null) continue;
            PresoObjAllocCCTNode.checkMethodIdForNodeFromVM(runtimeMemoryCCTNodeArray[i]);
        }
        JMethodIdTable.getDefault().getNamesForMethodIds(profilerClient);
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromSnapshot(MemoryResultsSnapshot memoryResultsSnapshot, RuntimeMemoryCCTNode runtimeMemoryCCTNode, String string) {
        PresoObjAllocCCTNode presoObjAllocCCTNode = PresoObjAllocCCTNode.generateMirrorNode(runtimeMemoryCCTNode);
        PresoObjAllocCCTNode.assignNamesToNodesFromSnapshot(memoryResultsSnapshot, presoObjAllocCCTNode, string);
        return presoObjAllocCCTNode;
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode runtimeMemoryCCTNode, String string) throws ClientUtils.TargetAppOrVMTerminated {
        PresoObjAllocCCTNode presoObjAllocCCTNode = PresoObjAllocCCTNode.generateMirrorNode(runtimeMemoryCCTNode);
        PresoObjAllocCCTNode.assignNamesToNodesFromVM(profilerClient, presoObjAllocCCTNode, string);
        return presoObjAllocCCTNode;
    }

    public CCTNode getChild(int n) {
        if (n < this.children.length) {
            return this.children[n];
        }
        return null;
    }

    public CCTNode[] getChildren() {
        return this.children;
    }

    public int getIndexOfChild(Object object) {
        for (int i = 0; i < this.children.length; ++i) {
            if ((PresoObjAllocCCTNode)object != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public String[] getMethodClassNameAndSig() {
        return new String[]{this.className, this.methodName, this.methodSig};
    }

    public int getNChildren() {
        if (this.children != null) {
            return this.children.length;
        }
        return 0;
    }

    public String getNodeName() {
        if (this.methodId != 0) {
            return this.nodeName;
        }
        return this.className;
    }

    public CCTNode getParent() {
        return this.parent;
    }

    public void sortChildren(int n, boolean bl) {
        int n2 = this.getNChildren();
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.children[i].sortChildren(n, bl);
        }
        if (n2 > 1) {
            switch (n) {
                case 1: {
                    this.sortChildrenByName(bl);
                    break;
                }
                case 2: {
                    this.sortChildrenByAllocObjSize(bl);
                    break;
                }
                case 3: {
                    this.sortChildrenByAllocObjNumber(bl);
                }
            }
        }
    }

    public String toString() {
        return this.getNodeName();
    }

    protected static void assignNamesToNodesFromSnapshot(MemoryResultsSnapshot memoryResultsSnapshot, PresoObjAllocCCTNode presoObjAllocCCTNode, String string) {
        presoObjAllocCCTNode.className = StringUtils.userFormClassName(string);
        presoObjAllocCCTNode.setFullClassAndMethodInfo(memoryResultsSnapshot.getJMethodIdTable());
    }

    protected static void assignNamesToNodesFromVM(ProfilerClient profilerClient, PresoObjAllocCCTNode presoObjAllocCCTNode, String string) throws ClientUtils.TargetAppOrVMTerminated {
        JMethodIdTable.getDefault().getNamesForMethodIds(profilerClient);
        presoObjAllocCCTNode.className = StringUtils.userFormClassName(string);
        presoObjAllocCCTNode.setFullClassAndMethodInfo(JMethodIdTable.getDefault());
    }

    protected static PresoObjAllocCCTNode generateMirrorNode(RuntimeMemoryCCTNode runtimeMemoryCCTNode) {
        PresoObjAllocCCTNode presoObjAllocCCTNode = new PresoObjAllocCCTNode(runtimeMemoryCCTNode);
        Object object = runtimeMemoryCCTNode.children;
        if (object != null) {
            if (object instanceof RuntimeMemoryCCTNode) {
                PresoObjAllocCCTNode presoObjAllocCCTNode2;
                presoObjAllocCCTNode.children = new PresoObjAllocCCTNode[1];
                presoObjAllocCCTNode.children[0] = presoObjAllocCCTNode2 = PresoObjAllocCCTNode.generateMirrorNode((RuntimeMemoryCCTNode)object);
                presoObjAllocCCTNode2.parent = presoObjAllocCCTNode;
                presoObjAllocCCTNode.nCalls += presoObjAllocCCTNode2.nCalls;
                presoObjAllocCCTNode.totalObjSize += presoObjAllocCCTNode2.totalObjSize;
            } else {
                RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])object;
                int n = runtimeMemoryCCTNodeArray.length;
                if (n > 0) {
                    presoObjAllocCCTNode.children = new PresoObjAllocCCTNode[n];
                    for (int i = 0; i < n; ++i) {
                        PresoObjAllocCCTNode presoObjAllocCCTNode3;
                        presoObjAllocCCTNode.children[i] = presoObjAllocCCTNode3 = PresoObjAllocCCTNode.generateMirrorNode(runtimeMemoryCCTNodeArray[i]);
                        presoObjAllocCCTNode3.parent = presoObjAllocCCTNode;
                        presoObjAllocCCTNode.nCalls += presoObjAllocCCTNode3.nCalls;
                        presoObjAllocCCTNode.totalObjSize += presoObjAllocCCTNode3.totalObjSize;
                    }
                }
            }
        }
        return presoObjAllocCCTNode;
    }

    protected boolean setFullClassAndMethodInfo(JMethodIdTable jMethodIdTable) {
        int n;
        if (this.methodId != 0) {
            JMethodIdTable.JMethodIdTableEntry jMethodIdTableEntry = jMethodIdTable.getEntry(this.methodId);
            this.className = jMethodIdTableEntry.className.replace('/', '.');
            this.methodName = jMethodIdTableEntry.methodName;
            this.methodSig = jMethodIdTableEntry.methodSig;
            this.nodeName = VM_ALLOC_CLASS.equals(this.className) && VM_ALLOC_METHOD.equals(this.methodName) ? VM_ALLOC_TEXT : MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(this.className, this.methodName, this.methodSig).toFormatted();
        }
        boolean bl = !this.className.equals("org.netbeans.lib.profiler.server.ProfilerServer");
        boolean bl2 = true;
        if (this.children != null) {
            for (n = 0; n < this.children.length; ++n) {
                if (this.children[n].setFullClassAndMethodInfo(jMethodIdTable)) continue;
                bl2 = false;
                this.children[n] = null;
            }
        }
        if (!bl2) {
            boolean bl3;
            n = 0;
            for (bl3 = false; bl3 < this.children.length; bl3 += 1) {
                n += this.children[bl3] != null ? 1 : 0;
            }
            boolean bl4 = bl3 = n > 0;
            if (!bl3) {
                this.children = null;
            } else {
                PresoObjAllocCCTNode[] presoObjAllocCCTNodeArray = new PresoObjAllocCCTNode[n];
                int n2 = 0;
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) continue;
                    presoObjAllocCCTNodeArray[n2++] = this.children[i];
                }
                this.children = presoObjAllocCCTNodeArray;
            }
            if (this.methodName == null || this.methodName.equals("main") && this.methodSig.equals("([Ljava/lang/String;)V")) {
                return true;
            }
            return bl3;
        }
        return bl;
    }

    protected static void checkMethodIdForNodeFromVM(RuntimeMemoryCCTNode runtimeMemoryCCTNode) {
        Object object;
        if (runtimeMemoryCCTNode.methodId != 0) {
            JMethodIdTable.getDefault().checkMethodId(runtimeMemoryCCTNode.methodId);
        }
        if ((object = runtimeMemoryCCTNode.children) != null) {
            if (object instanceof RuntimeMemoryCCTNode) {
                PresoObjAllocCCTNode.checkMethodIdForNodeFromVM((RuntimeMemoryCCTNode)object);
            } else {
                RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])object;
                for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
                    PresoObjAllocCCTNode.checkMethodIdForNodeFromVM(runtimeMemoryCCTNodeArray[i]);
                }
            }
        }
    }

    protected void sortChildrenByAllocObjNumber(boolean bl) {
        int n = this.children.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.children[i].nCalls;
        }
        this.sortLongs(lArray, bl);
    }

    protected void sortChildrenByAllocObjSize(boolean bl) {
        int n = this.children.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.children[i].totalObjSize;
        }
        this.sortLongs(lArray, bl);
    }

    protected void sortChildrenByName(boolean bl) {
        int n = this.children.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.children[i].getNodeName();
        }
        this.sortStrings(stringArray, bl);
    }

    protected void sortFloats(float[] fArray, boolean bl) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0 && (!bl ? fArray[j - 1] < fArray[j] : fArray[j - 1] > fArray[j]); --j) {
                float f = fArray[j];
                fArray[j] = fArray[j - 1];
                fArray[j - 1] = f;
                PresoObjAllocCCTNode presoObjAllocCCTNode = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = presoObjAllocCCTNode;
            }
        }
    }

    protected void sortInts(int[] nArray, boolean bl) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0 && (!bl ? nArray[j - 1] < nArray[j] : nArray[j - 1] > nArray[j]); --j) {
                int n2 = nArray[j];
                nArray[j] = nArray[j - 1];
                nArray[j - 1] = n2;
                PresoObjAllocCCTNode presoObjAllocCCTNode = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = presoObjAllocCCTNode;
            }
        }
    }

    protected void sortLongs(long[] lArray, boolean bl) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0 && (!bl ? lArray[j - 1] < lArray[j] : lArray[j - 1] > lArray[j]); --j) {
                long l = lArray[j];
                lArray[j] = lArray[j - 1];
                lArray[j - 1] = l;
                PresoObjAllocCCTNode presoObjAllocCCTNode = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = presoObjAllocCCTNode;
            }
        }
    }

    protected void sortStrings(String[] stringArray, boolean bl) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0 && (!bl ? stringArray[j - 1].compareTo(stringArray[j]) < 0 : stringArray[j - 1].compareTo(stringArray[j]) > 0); --j) {
                String string = stringArray[j];
                stringArray[j] = stringArray[j - 1];
                stringArray[j - 1] = string;
                PresoObjAllocCCTNode presoObjAllocCCTNode = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = presoObjAllocCCTNode;
            }
        }
    }
}

