/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.datasource.descriptor;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.Positionable;
import com.sun.tools.visualvm.core.model.Model;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataSourceDescriptor<X extends DataSource>
extends Model
implements Positionable {
    public static final String PROPERTY_ICON = "prop_icon";
    public static final String PROPERTY_NAME = "prop_name";
    public static final String PROPERTY_DESCRIPTION = "prop_description";
    public static final String PROPERTY_PREFERRED_POSITION = "prop_preferred_position";
    public static final String PROPERTY_EXPANSION_POLICY = "prop_expansion_policy";
    public static final int EXPAND_NEVER = 0;
    public static final int EXPAND_ON_FIRST_CHILD = 1;
    public static final int EXPAND_ON_EACH_FIRST_CHILD = 2;
    public static final int EXPAND_ON_EACH_NEW_CHILD = 3;
    public static final int EXPAND_ON_EACH_CHILD_CHANGE = 4;
    private X dataSource;
    private Image icon;
    private String name;
    private String description;
    private int preferredPosition;
    private int autoExpansionPolicy;
    private final PropertyChangeSupport changeSupport;

    public DataSourceDescriptor(X dataSource) {
        this(dataSource, dataSource != null ? dataSource.toString() : null, null, null, 0x7FFFFFFE, 1);
    }

    public DataSourceDescriptor(X ds, String n, String desc, Image ic, int pos, int aep) {
        if (ds == null) {
            throw new NullPointerException("DataSource cannot be null");
        }
        this.dataSource = ds;
        this.changeSupport = this.dataSource != null ? new PropertyChangeSupport(this.dataSource) : null;
        this.name = n;
        this.description = desc;
        this.icon = ic;
        this.preferredPosition = pos;
        this.autoExpansionPolicy = aep;
    }

    public Image getIcon() {
        return this.icon;
    }

    public boolean supportsRename() {
        return false;
    }

    public void setName(String newName) {
        if (!this.supportsRename()) {
            throw new UnsupportedOperationException("Rename not supported for this descriptor");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String oldName = this.name;
        this.name = newName;
        ((DataSource)this.getDataSource()).getStorage().setCustomProperties(new String[]{PROPERTY_NAME}, new String[]{newName});
        if (this.getChangeSupport() != null) {
            this.getChangeSupport().firePropertyChange(PROPERTY_NAME, oldName, newName);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int getPreferredPosition() {
        return this.preferredPosition;
    }

    public int getAutoExpansionPolicy() {
        return this.autoExpansionPolicy;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.getChangeSupport() != null) {
            this.getChangeSupport().addPropertyChangeListener(listener);
        }
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.getChangeSupport() != null) {
            this.getChangeSupport().addPropertyChangeListener(propertyName, listener);
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.getChangeSupport() != null) {
            this.getChangeSupport().removePropertyChangeListener(listener);
        }
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.getChangeSupport() != null) {
            this.getChangeSupport().removePropertyChangeListener(propertyName, listener);
        }
    }

    protected final X getDataSource() {
        return this.dataSource;
    }

    protected void setDescription(String newDescription) {
        if (this.description == null && newDescription == null) {
            return;
        }
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.getChangeSupport() != null) {
            this.getChangeSupport().firePropertyChange(PROPERTY_DESCRIPTION, oldDescription, newDescription);
        }
    }

    protected void setIcon(Image newIcon) {
        if (this.icon == null && newIcon == null) {
            return;
        }
        Image oldIcon = this.icon;
        this.icon = newIcon;
        if (this.getChangeSupport() != null) {
            this.getChangeSupport().firePropertyChange(PROPERTY_ICON, oldIcon, newIcon);
        }
    }

    protected void setPreferredPosition(int newPosition) {
        int oldPosition = this.preferredPosition;
        this.preferredPosition = newPosition;
        if (this.getChangeSupport() != null) {
            this.getChangeSupport().firePropertyChange(PROPERTY_PREFERRED_POSITION, oldPosition, newPosition);
        }
    }

    protected void getAutoExpansionPolicy(int newPolicy) {
        int oldPolicy = this.autoExpansionPolicy;
        this.autoExpansionPolicy = newPolicy;
        if (this.getChangeSupport() != null) {
            this.getChangeSupport().firePropertyChange(PROPERTY_EXPANSION_POLICY, oldPolicy, newPolicy);
        }
    }

    protected final PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }
}

