/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host.views.overview;

import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.host.views.overview.BoundedDynamicXYChartModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChartModel;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.openide.util.NbBundle;

class ChartsSupport {
    public static final int MINIMUM_CHART_HEIGHT = 275;

    ChartsSupport() {
    }

    public static class SwapMemoryMetricsChart
    extends Chart {
        protected void setupModel(BoundedDynamicXYChartModel xyChartModel) {
            xyChartModel.setupModel(new String[]{NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Used_swap")}, new Color[]{new Color(255, 127, 127)});
        }

        protected SynchronousXYChart createChart() {
            SynchronousXYChart xyChart = new SynchronousXYChart(2, 50, 0.01);
            xyChart.setVerticalAxisValueDivider(0x100000);
            xyChart.setVerticalAxisValueString("M");
            xyChart.setTopChartMargin(20);
            xyChart.denySelection();
            xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
            return xyChart;
        }

        protected JPanel createBigLegend() {
            JLabel liveThreads = new JLabel(this.getModel().getSeriesName(0), (Icon)new ColorIcon(this.getModel().getSeriesColor(0), Color.BLACK, 18, 9), 10);
            liveThreads.setOpaque(false);
            liveThreads.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel legendPanel = new JPanel();
            legendPanel.setOpaque(false);
            legendPanel.add(liveThreads);
            return legendPanel;
        }

        protected JPanel createSmallLegend() {
            return null;
        }
    }

    public static class PhysicalMemoryMetricsChart
    extends Chart {
        protected void setupModel(BoundedDynamicXYChartModel xyChartModel) {
            xyChartModel.setupModel(new String[]{NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Used_memory")}, new Color[]{new Color(255, 127, 127)});
        }

        protected SynchronousXYChart createChart() {
            SynchronousXYChart xyChart = new SynchronousXYChart(2, 50, 0.01);
            xyChart.setVerticalAxisValueDivider(0x100000);
            xyChart.setVerticalAxisValueString("M");
            xyChart.setTopChartMargin(20);
            xyChart.denySelection();
            xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
            return xyChart;
        }

        protected JPanel createBigLegend() {
            JLabel liveThreads = new JLabel(this.getModel().getSeriesName(0), (Icon)new ColorIcon(this.getModel().getSeriesColor(0), Color.BLACK, 18, 9), 10);
            liveThreads.setOpaque(false);
            liveThreads.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel legendPanel = new JPanel();
            legendPanel.setOpaque(false);
            legendPanel.add(liveThreads);
            return legendPanel;
        }

        protected JPanel createSmallLegend() {
            return null;
        }
    }

    public static class CPUMetricsChart
    extends Chart {
        protected void setupModel(BoundedDynamicXYChartModel xyChartModel) {
            xyChartModel.setupModel(new String[]{NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Load_average")}, new Color[]{new Color(255, 127, 127)});
        }

        protected SynchronousXYChart createChart() {
            SynchronousXYChart xyChart = new SynchronousXYChart(2, 50, 0.01);
            xyChart.setVerticalAxisValueDivider(1000);
            xyChart.setVerticalAxisValueString("");
            xyChart.setTopChartMargin(20);
            xyChart.denySelection();
            xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
            return xyChart;
        }

        protected JPanel createBigLegend() {
            JLabel liveThreads = new JLabel(this.getModel().getSeriesName(0), (Icon)new ColorIcon(this.getModel().getSeriesColor(0), Color.BLACK, 18, 9), 10);
            liveThreads.setOpaque(false);
            liveThreads.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel legendPanel = new JPanel();
            legendPanel.setOpaque(false);
            legendPanel.add(liveThreads);
            return legendPanel;
        }

        protected JPanel createSmallLegend() {
            return null;
        }
    }

    public static abstract class Chart
    extends GraphPanel
    implements ChartModelListener {
        private SynchronousXYChart xyChart;
        private BoundedDynamicXYChartModel xyChartModel;
        private JPanel bigLegendPanel;
        private JPanel smallLegendPanel;

        public Chart() {
            long time = System.currentTimeMillis();
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            GlobalPreferences preferences = GlobalPreferences.sharedInstance();
            this.xyChartModel = new BoundedDynamicXYChartModel(preferences.getMonitoredHostCache() * 60 / preferences.getMonitoredHostPoll()){

                public long getMaxDisplayYValue(int seriesIndex) {
                    return this.getMaxYValue(0);
                }
            };
            this.setupModel(this.xyChartModel);
            this.xyChart = this.createChart();
            this.xyChart.setBackgroundPaint((Paint)this.getBackground());
            this.xyChart.setModel((SynchronousXYChartModel)this.xyChartModel);
            this.xyChart.setFitToWindow();
            this.xyChart.setupInitialAppearance(time, time + 1200L, 0L, 2L);
            this.add((Component)this.xyChart, "Center");
            this.bigLegendPanel = this.createBigLegend();
            this.smallLegendPanel = this.createSmallLegend();
            ToolTipManager.sharedInstance().registerComponent((JComponent)this.xyChart);
        }

        protected abstract SynchronousXYChart createChart();

        protected abstract void setupModel(BoundedDynamicXYChartModel var1);

        protected abstract JPanel createBigLegend();

        protected abstract JPanel createSmallLegend();

        public SynchronousXYChart getChart() {
            return this.xyChart;
        }

        public BoundedDynamicXYChartModel getModel() {
            return this.xyChartModel;
        }

        public JPanel getBigLegendPanel() {
            return this.bigLegendPanel;
        }

        public JPanel getSmallLegendPanel() {
            return this.smallLegendPanel;
        }

        public void chartDataChanged() {
        }

        public void setToolTipText(String toolTipText) {
            super.setToolTipText(toolTipText);
            this.xyChart.setToolTipText(toolTipText);
        }
    }
}

