/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvmstat.application;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.core.ui.DesktopUtils;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.jvmstat.application.JvmstatApplication;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.event.HostEvent;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmstatApplicationProvider
implements DataChangeListener<Host> {
    private static final Logger LOGGER = Logger.getLogger(JvmstatApplicationProvider.class.getName());
    private static JvmstatApplicationProvider instance;
    private final Map<String, JvmstatApplication> applications = new HashMap<String, JvmstatApplication>();

    static synchronized JvmstatApplicationProvider sharedInstance() {
        if (instance == null) {
            instance = new JvmstatApplicationProvider();
        }
        return instance;
    }

    public void dataChanged(DataChangeEvent<Host> event) {
        Set newHosts = event.getAdded();
        for (final Host host : newHosts) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    JvmstatApplicationProvider.this.processNewHost(host);
                }
            });
        }
    }

    private void processNewHost(final Host host) {
        if (host == Host.UNKNOWN_HOST) {
            return;
        }
        final boolean[] firstEvent = new boolean[]{true};
        HostListener hostListener = null;
        final MonitoredHost monitoredHost = this.getMonitoredHost(host);
        if (monitoredHost == null) {
            this.rescheduleProcessNewHost(host);
            return;
        }
        monitoredHost.setInterval(GlobalPreferences.sharedInstance().getMonitoredHostPoll() * 1000);
        if (host == Host.LOCALHOST) {
            this.checkForBrokenJps(monitoredHost);
        }
        try {
            this.processNewApplicationsByPids(host, monitoredHost.activeVms());
            hostListener = new HostListener(){

                public void vmStatusChanged(VmStatusChangeEvent e) {
                    if (firstEvent[0]) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Monitored Host (" + host.getHostName() + ") status changed - adding all active applications");
                        }
                        firstEvent[0] = false;
                        JvmstatApplicationProvider.this.processNewApplicationsByPids(host, e.getActive());
                    } else {
                        JvmstatApplicationProvider.this.processNewApplicationsByPids(host, e.getStarted());
                        JvmstatApplicationProvider.this.processTerminatedApplicationsByPids(host, e.getTerminated());
                    }
                }

                public void disconnected(HostEvent e) {
                    JvmstatApplicationProvider.this.processDisconnectedHost(host, monitoredHost, this);
                    JvmstatApplicationProvider.this.rescheduleProcessNewHost(host);
                }
            };
            monitoredHost.addHostListener(hostListener);
        }
        catch (MonitorException e) {
            ErrorManager.getDefault().notify(256, (Throwable)e);
            this.rescheduleProcessNewHost(host);
            return;
        }
    }

    private void processDisconnectedHost(Host host, MonitoredHost monitoredHost, HostListener listener) {
        try {
            monitoredHost.removeHostListener(listener);
        }
        catch (MonitorException ex) {
            // empty catch block
        }
        Set jvmstatApplications = host.getRepository().getDataSources(JvmstatApplication.class);
        for (JvmstatApplication application : jvmstatApplications) {
            application.setStateImpl(0);
        }
        host.getRepository().removeDataSources(jvmstatApplications);
    }

    private void processNewApplicationsByPids(Host host, Set<Integer> applicationPids) {
        HashSet<JvmstatApplication> newApplications = new HashSet<JvmstatApplication>();
        for (int applicationPid : applicationPids) {
            if (Application.CURRENT_APPLICATION.getPid() == applicationPid) continue;
            String appId = this.createId(host, applicationPid);
            JvmstatApplication application = new JvmstatApplication(host, appId, applicationPid);
            if (this.applications.containsKey(appId)) continue;
            application.jvm = JvmFactory.getJVMFor((Application)application);
            this.applications.put(appId, application);
            newApplications.add(application);
        }
        host.getRepository().addDataSources(newApplications);
    }

    private void processTerminatedApplicationsByPids(Host host, Set<Integer> applicationPids) {
        HashSet<JvmstatApplication> finishedApplications = new HashSet<JvmstatApplication>();
        for (int applicationPid : applicationPids) {
            String appId = this.createId(host, applicationPid);
            if (!this.applications.containsKey(appId)) continue;
            JvmstatApplication application = this.applications.get(appId);
            if (application != null) {
                finishedApplications.add(application);
                application.setStateImpl(0);
            }
            this.applications.remove(appId);
        }
        host.getRepository().removeDataSources(finishedApplications);
    }

    private String createId(Host host, int pid) {
        return host.getHostName() + "-" + pid;
    }

    void removeFromMap(JvmstatApplication jvmstatApplication) {
        this.applications.remove(jvmstatApplication.getId());
    }

    private void checkForBrokenJps(MonitoredHost monitoredHost) {
        try {
            if (monitoredHost.activeVms().size() != 0) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        String link = DesktopUtils.isBrowseAvailable() ? NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jsp_Link") : NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jsp_NoLink");
        String message = NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jps", (Object)link);
        final HTMLLabel label = new HTMLLabel(message){

            protected void showURL(URL url) {
                try {
                    DesktopUtils.browse((URI)url.toURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)label, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        });
    }

    private MonitoredHost getMonitoredHost(Host host) {
        try {
            return MonitoredHost.getMonitoredHost(host.getHostName());
        }
        catch (URISyntaxException ex) {
            ErrorManager.getDefault().notify(256, (Throwable)ex);
        }
        catch (MonitorException monitorException) {
            // empty catch block
        }
        return null;
    }

    private void rescheduleProcessNewHost(final Host host) {
        int interval = GlobalPreferences.sharedInstance().getMonitoredHostPoll();
        Timer timer = new Timer(interval * 1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (!host.isRemoved()) {
                            JvmstatApplicationProvider.this.processNewHost(host);
                        }
                    }
                });
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public static void register() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)JvmstatApplicationProvider.sharedInstance(), Host.class);
    }
}

