/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AnalysisControllerUI
extends JPanel {
    private static final String INFO_STRING = NbBundle.getMessage(AnalysisControllerUI.class, (String)"AnalysisControllerUI_InfoString");
    private static final String RULES_TO_APPLY_STRING = NbBundle.getMessage(AnalysisControllerUI.class, (String)"AnalysisControllerUI_RulesToApplyString");
    private static final String PROCESSING_RULES_MSG = NbBundle.getMessage(AnalysisControllerUI.class, (String)"AnalysisControllerUI_ProcessingRulesMsg");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(AnalysisControllerUI.class, (String)"AnalysisControllerUI_CancelButtonText");
    private static final String PERFORM_BUTTON_TEXT = NbBundle.getMessage(AnalysisControllerUI.class, (String)"AnalysisControllerUI_PerformButtonText");
    private static final String ANALYSIS_RESULTS_TEXT = NbBundle.getMessage(AnalysisControllerUI.class, (String)"AnalysisControllerUI_AnalysisResultsText");
    private static final String CONTROLLER_NAME = NbBundle.getMessage(AnalysisControllerUI.class, (String)"AnalysisControllerUI_ControllerName");
    private static final String CONTROLLER_DESCR = NbBundle.getMessage(AnalysisControllerUI.class, (String)"AnalysisControllerUI_ControllerDescr");
    private AbstractButton presenter;
    private AnalysisController analysisController;
    private HTMLTextArea resultsArea;
    private HTMLTextArea settingsArea;
    private JButton performButton;
    private JPanel resultsContainer;
    private JPanel rulesContainer;
    private JSplitPane contentsSplit;

    public AnalysisControllerUI(AnalysisController analysisController) {
        this.analysisController = analysisController;
        this.initComponents();
        this.initRules();
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    public void displayNewRules() {
        this.initRules();
    }

    public void setResult(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnalysisControllerUI.this.resultsContainer.removeAll();
                HTMLTextArea hTMLTextArea = new HTMLTextArea(string){

                    protected void showURL(URL uRL) {
                        AnalysisControllerUI.this.analysisController.showURL(uRL);
                    }
                };
                try {
                    hTMLTextArea.setCaretPosition(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AnalysisControllerUI.this.resultsContainer.add((Component)hTMLTextArea, "Center");
                AnalysisControllerUI.this.resultsContainer.invalidate();
                AnalysisControllerUI.this.revalidate();
                AnalysisControllerUI.this.repaint();
            }
        });
    }

    private boolean[] getRulesSelection() {
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        Component[] objectArray = this.rulesContainer.getComponents();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Component component = objectArray[i];
            if (!(component instanceof JCheckBox) || !((JCheckBox)component).getActionCommand().equals("RULE_CHECKBOX")) continue;
            arrayList.add((JCheckBox)component);
        }
        boolean[] blArray = new boolean[arrayList.size()];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = ((JCheckBox)arrayList.get(n)).isSelected();
        }
        return blArray;
    }

    private void cancelAnalysis() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnalysisControllerUI.this.resultsContainer.removeAll();
                AnalysisControllerUI.this.resultsContainer.invalidate();
                AnalysisControllerUI.this.revalidate();
                AnalysisControllerUI.this.repaint();
                AnalysisControllerUI.this.performButton.setEnabled(true);
            }
        });
        this.analysisController.cancelAnalysis();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JSeparator jSeparator = new JSeparator(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, 1);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 1);
            }
        };
        jSeparator.setBackground(this.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jSeparator, gridBagConstraints);
        this.settingsArea = new HTMLTextArea();
        this.settingsArea.setText("<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/rules.png'>&nbsp;&nbsp;" + RULES_TO_APPLY_STRING + "</b><br><hr>&nbsp;&nbsp;&nbsp;&nbsp;Searching for rules...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.settingsArea, gridBagConstraints);
        this.performButton = new JButton(PERFORM_BUTTON_TEXT);
        this.performButton.setEnabled(false);
        this.performButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisControllerUI.this.performAnalysis();
            }
        });
        this.rulesContainer = new JPanel(new GridBagLayout());
        this.rulesContainer.setOpaque(true);
        JScrollPane jScrollPane = new JScrollPane(this.rulesContainer, 20, 30){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = Math.min(dimension.height, 160);
                return new Dimension(dimension.width, n);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setBackground(this.settingsArea.getBackground());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 15, 5, 5);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.resultsArea = new HTMLTextArea();
        this.resultsArea.setText("<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/properties.png'>&nbsp;&nbsp;" + ANALYSIS_RESULTS_TEXT + "</b><br><hr>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.resultsArea, gridBagConstraints);
        this.resultsContainer = new JPanel(new BorderLayout());
        this.resultsContainer.setOpaque(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.resultsContainer, 20, 30){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = Math.min(dimension.height, 160);
                return new Dimension(dimension.width, n);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane2.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane2.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane2.setBackground(this.settingsArea.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 15, 5, 8);
        this.add((Component)jScrollPane2, gridBagConstraints);
        this.setBackground(this.settingsArea.getBackground());
        this.rulesContainer.setBackground(this.settingsArea.getBackground());
        this.resultsContainer.setBackground(this.settingsArea.getBackground());
    }

    private void initRules() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                final List<Rule> list = AnalysisControllerUI.this.analysisController.getRules();
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = AnalysisControllerUI.this.getTreeLock();
                        synchronized (object) {
                            GridBagConstraints gridBagConstraints;
                            AnalysisControllerUI.this.rulesContainer.removeAll();
                            for (int i = 0; i < list.size(); ++i) {
                                final Rule rule = (Rule)list.get(i);
                                String string = rule.getDisplayName();
                                String string2 = rule.getDescription();
                                JComponent jComponent = rule.getCustomizer();
                                final String string3 = rule.getHTMLDescription();
                                JCheckBox jCheckBox = new JCheckBox(string);
                                jCheckBox.setActionCommand("RULE_CHECKBOX");
                                jCheckBox.setOpaque(false);
                                jCheckBox.setToolTipText(string2);
                                gridBagConstraints = new GridBagConstraints();
                                gridBagConstraints.gridx = 0;
                                gridBagConstraints.gridy = i;
                                gridBagConstraints.gridwidth = jComponent == null && string3 == null ? 0 : 1;
                                gridBagConstraints.fill = 0;
                                gridBagConstraints.anchor = 17;
                                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                                AnalysisControllerUI.this.rulesContainer.add((Component)jCheckBox, gridBagConstraints);
                                jCheckBox.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        AnalysisControllerUI.this.updatePerformButton();
                                    }
                                });
                                if (string3 != null) {
                                    HTMLLabel hTMLLabel = new HTMLLabel("<a href='#info'>" + INFO_STRING + "</a>"){

                                        protected void showURL(URL uRL) {
                                            DescriptionDisplayer.showDescription(rule, string3);
                                        }
                                    };
                                    hTMLLabel.setOpaque(false);
                                    gridBagConstraints = new GridBagConstraints();
                                    gridBagConstraints.gridx = 1;
                                    gridBagConstraints.gridy = i;
                                    gridBagConstraints.gridwidth = jComponent == null ? 0 : 1;
                                    gridBagConstraints.fill = 0;
                                    gridBagConstraints.anchor = 17;
                                    gridBagConstraints.insets = new Insets(0, 2, 0, 0);
                                    AnalysisControllerUI.this.rulesContainer.add((Component)hTMLLabel, gridBagConstraints);
                                }
                                if (jComponent == null) continue;
                                jComponent.setOpaque(false);
                                gridBagConstraints = new GridBagConstraints();
                                gridBagConstraints.gridx = 2;
                                gridBagConstraints.gridy = i;
                                gridBagConstraints.gridwidth = 0;
                                gridBagConstraints.fill = 0;
                                gridBagConstraints.anchor = 17;
                                gridBagConstraints.insets = new Insets(0, 8, 0, 5);
                                AnalysisControllerUI.this.rulesContainer.add((Component)jComponent, gridBagConstraints);
                            }
                            JPanel jPanel = new JPanel(new GridBagLayout());
                            jPanel.setOpaque(false);
                            gridBagConstraints = new GridBagConstraints();
                            gridBagConstraints.gridx = 0;
                            gridBagConstraints.gridy = list.size();
                            gridBagConstraints.gridwidth = 0;
                            gridBagConstraints.weightx = 1.0;
                            gridBagConstraints.fill = 2;
                            gridBagConstraints.anchor = 17;
                            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                            AnalysisControllerUI.this.rulesContainer.add((Component)jPanel, gridBagConstraints);
                            gridBagConstraints = new GridBagConstraints();
                            gridBagConstraints.gridx = 1;
                            gridBagConstraints.gridy = 3;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.fill = 0;
                            gridBagConstraints.anchor = 13;
                            gridBagConstraints.insets = new Insets(3, 0, 0, 8);
                            AnalysisControllerUI.this.add((Component)AnalysisControllerUI.this.performButton, gridBagConstraints);
                            AnalysisControllerUI.this.settingsArea.setText("<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/rules.png'>&nbsp;&nbsp;" + RULES_TO_APPLY_STRING + "</b><br><hr>");
                            AnalysisControllerUI.this.updatePerformButton();
                        }
                    }
                });
            }
        });
    }

    private void performAnalysis() {
        this.performButton.setEnabled(false);
        BoundedRangeModel boundedRangeModel = this.analysisController.performAnalysis(this.getRulesSelection());
        this.resultsContainer.removeAll();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)new JLabel(PROCESSING_RULES_MSG + "  "), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        jPanel.add((Component)new JProgressBar(boundedRangeModel), gridBagConstraints);
        JButton jButton = new JButton(CANCEL_BUTTON_TEXT);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisControllerUI.this.cancelAnalysis();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        jPanel.add((Component)jButton, gridBagConstraints);
        this.resultsContainer.add((Component)jPanel, "North");
        this.resultsContainer.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void updatePerformButton() {
        if (this.analysisController.isAnalysisRunning()) {
            this.performButton.setEnabled(false);
        } else {
            boolean[] blArray = this.getRulesSelection();
            if (blArray.length > 0) {
                for (boolean bl : blArray) {
                    if (!bl) continue;
                    this.performButton.setEnabled(true);
                    return;
                }
            }
            this.performButton.setEnabled(false);
        }
    }

    private static class Presenter
    extends JToggleButton {
        private static ImageIcon ICON_INFO = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/memoryLint.png"));

        public Presenter() {
            this.setText(CONTROLLER_NAME);
            this.setToolTipText(CONTROLLER_DESCR);
            this.setIcon(ICON_INFO);
            this.setMargin(new Insets(this.getMargin().top, this.getMargin().top, this.getMargin().bottom, this.getMargin().top));
        }
    }

    private static class DescriptionDisplayer
    extends JPanel {
        private DescriptionDisplayer(URL uRL, String string) {
            this.initComponents(uRL, string);
        }

        public static void showDescription(Rule rule, String string) {
            Class<?> clazz = rule.getClass();
            URL uRL = clazz.getResource(clazz.getSimpleName() + ".class");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new DescriptionDisplayer(uRL, string), rule.getDisplayName(), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
            Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
            dialog.pack();
            dialog.setVisible(true);
        }

        private void initComponents(URL uRL, String string) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            HTMLTextArea hTMLTextArea = new HTMLTextArea();
            HTMLDocument hTMLDocument = (HTMLDocument)hTMLTextArea.getDocument();
            hTMLTextArea.setText(string);
            hTMLTextArea.setCaretPosition(0);
            hTMLDocument.setBase(uRL);
            JScrollPane jScrollPane = new JScrollPane((Component)hTMLTextArea, 20, 30);
            jScrollPane.setPreferredSize(new Dimension(375, 220));
            this.add((Component)jScrollPane, "Center");
        }
    }
}

