/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.modules.profiler.heapwalk.FieldsBrowserController;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.ui.FieldTreeCellRenderer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class FieldsBrowserControllerUI
extends JTitledPanel {
    private static final String VIEW_TITLE_FIELDS = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ViewTitleFields");
    private static final String VIEW_TITLE_STATIC_FIELDS = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ViewTitleStaticFields");
    private static final String NO_INSTANCE_SELECTED_MSG = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_NoInstanceSelectedMsg");
    private static final String NO_CLASS_SELECTED_MSG = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_NoClassSelectedMsg");
    private static final String SHOW_LOOP_ITEM_TEXT = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ShowLoopItemText");
    private static final String SHOW_INSTANCE_ITEM_TEXT = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ShowInstanceItemText");
    private static final String SHOW_IN_INSTANCES_ITEM_TEXT = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ShowInInstancesItemText");
    private static final String SHOW_CLASS_ITEM_TEXT = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ShowClassItemText");
    private static final String SHOW_IN_CLASSES_ITEM_TEXT = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ShowInClassesItemText");
    private static final String GO_TO_SOURCE_ITEM_TEXT = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_GoToSourceItemText");
    private static final String SHOW_HIDE_COLUMNS_STRING = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ShowHideColumnsString");
    private static final String FIELD_COLUMN_NAME = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_FieldColumnName");
    private static final String FIELD_COLUMN_DESCR = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_FieldColumnDescr");
    private static final String TYPE_COLUMN_NAME = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_TypeColumnName");
    private static final String TYPE_COLUMN_DESCR = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_TypeColumnDescr");
    private static final String FULL_TYPE_COLUMN_NAME = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_FullTypeColumnName");
    private static final String FULL_TYPE_COLUMN_DESCR = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_FullTypeColumnDescr");
    private static final String VALUE_COLUMN_NAME = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ValueColumnName");
    private static final String VALUE_COLUMN_DESCR = NbBundle.getMessage(FieldsBrowserControllerUI.class, (String)"FieldsBrowserControllerUI_ValueColumnDescr");
    private static ImageIcon ICON_FIELDS = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/data.png"));
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private static final int columnCount = 4;
    private CardLayout contents;
    private ExtendedTreeTableModel fieldsListTableModel;
    private FieldTreeCellRenderer treeCellRenderer = new FieldTreeCellRenderer();
    private FieldsBrowserController fieldsBrowserController;
    private FieldsListTreeTableModel realFieldsListTableModel;
    private JMenuItem showClassItem;
    private JMenuItem showInstanceItem;
    private JMenuItem showLoopOriginItem;
    private JPanel dataPanel;
    private JPanel noDataPanel;
    private JPopupMenu cornerPopup;
    private JPopupMenu tablePopup;
    private JTreeTable fieldsListTable;
    private String filterValue = "";
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private boolean internalCornerButtonClick = false;
    private boolean needsUpdate = true;
    private boolean sortingOrder = true;
    private int sortingColumn = 0;

    public FieldsBrowserControllerUI(FieldsBrowserController fieldsBrowserController) {
        super(fieldsBrowserController.getRootMode() == 0 ? VIEW_TITLE_FIELDS : VIEW_TITLE_STATIC_FIELDS, (Icon)ICON_FIELDS, true);
        this.fieldsBrowserController = fieldsBrowserController;
        this.realFieldsListTableModel = new FieldsListTreeTableModel();
        this.fieldsListTableModel = new ExtendedTreeTableModel((AbstractTreeTableModel)this.realFieldsListTableModel);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && FieldsBrowserControllerUI.this.isShowing() && FieldsBrowserControllerUI.this.needsUpdate) {
                    FieldsBrowserControllerUI.this.update();
                }
            }
        });
        this.initColumnsData();
        this.initData();
        this.initComponents();
    }

    public void refreshView() {
        if (this.fieldsListTable != null) {
            this.fieldsListTable.updateTreeTable();
        }
    }

    public void selectNode(HeapWalkerNode heapWalkerNode) {
        this.fieldsListTable.selectNode((CCTNode)heapWalkerNode, true);
    }

    public void update() {
        if (this.isShowing()) {
            this.initData();
            if (this.contents != null) {
                if (this.fieldsListTableModel.getRoot() == null || this.fieldsListTableModel.getRoot() == FieldsBrowserController.EMPTY_CLASS_NODE || this.fieldsListTableModel.getRoot() == FieldsBrowserController.EMPTY_INSTANCE_NODE) {
                    this.contents.show(this.getContentPanel(), NO_DATA);
                } else {
                    this.contents.show(this.getContentPanel(), DATA);
                }
                this.fieldsListTable.resetTreeCellOffsetX();
            }
            this.needsUpdate = false;
        } else {
            this.needsUpdate = true;
        }
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realFieldsListTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.realFieldsListTableModel.getColumnName(i));
            jCheckBoxMenuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.fieldsListTable != null) {
                jCheckBoxMenuItem.setState(this.fieldsListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.fieldsListTable.getColumnModel();
        this.fieldsListTable.setTreeCellRenderer((EnhancedTreeCellRenderer)this.treeCellRenderer);
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int n = this.fieldsListTableModel.getRealColumn(i);
            if (n == 0) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                FieldsBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(n, !FieldsBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(n));
                FieldsBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                FieldsBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                FieldsBrowserControllerUI.this.setColumnsData();
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu jPopupMenu) {
        final JButton jButton = new JButton(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/hideColumn.png")));
        jButton.setToolTipText(SHOW_HIDE_COLUMNS_STRING);
        jButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 1));
        }
        jButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    FieldsBrowserControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (jPopupMenu.isVisible()) {
                    FieldsBrowserControllerUI.this.internalCornerButtonClick = true;
                    jButton.getModel().setArmed(false);
                } else {
                    FieldsBrowserControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        FieldsBrowserControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                    }
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !FieldsBrowserControllerUI.this.internalCornerButtonClick) {
                    FieldsBrowserControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        return jButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.showInstanceItem = new JMenuItem(this.fieldsBrowserController.getRootMode() == 0 ? SHOW_INSTANCE_ITEM_TEXT : SHOW_IN_INSTANCES_ITEM_TEXT);
        this.showInstanceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FieldsBrowserControllerUI.this.performDefaultAction();
            }
        });
        this.showInstanceItem.setFont(jPopupMenu.getFont().deriveFont(1));
        this.showClassItem = new JMenuItem(this.fieldsBrowserController.getRootMode() == 0 ? SHOW_IN_CLASSES_ITEM_TEXT : SHOW_CLASS_ITEM_TEXT);
        this.showClassItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapWalkerNode heapWalkerNode;
                int n = FieldsBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (n != -1 && (heapWalkerNode = (HeapWalkerNode)FieldsBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent()) instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)heapWalkerNode).hasInstance()) {
                    if (FieldsBrowserControllerUI.this.fieldsBrowserController.getRootMode() == 1) {
                        FieldsBrowserControllerUI.this.fieldsBrowserController.createNavigationHistoryPoint();
                    }
                    HeapWalkerInstanceNode heapWalkerInstanceNode = (HeapWalkerInstanceNode)heapWalkerNode;
                    FieldsBrowserControllerUI.this.fieldsBrowserController.navigateToClass(heapWalkerInstanceNode.getInstance().getJavaClass());
                }
            }
        });
        this.showLoopOriginItem = new JMenuItem(SHOW_LOOP_ITEM_TEXT);
        this.showLoopOriginItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapWalkerNode heapWalkerNode;
                int n = FieldsBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (n != -1 && (heapWalkerNode = (HeapWalkerNode)FieldsBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent()) instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)heapWalkerNode).isLoop()) {
                    FieldsBrowserControllerUI.this.selectNode(((HeapWalkerInstanceNode)heapWalkerNode).getLoopTo());
                }
            }
        });
        jPopupMenu.add(this.showInstanceItem);
        jPopupMenu.add(this.showClassItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.showLoopOriginItem);
        return jPopupMenu;
    }

    private void initColumnsData() {
        this.columnWidths = new int[3];
        this.columnNames = new String[4];
        this.columnToolTips = new String[4];
        this.columnRenderers = new TableCellRenderer[4];
        this.columnNames[0] = FIELD_COLUMN_NAME;
        this.columnToolTips[0] = FIELD_COLUMN_DESCR;
        this.columnNames[1] = TYPE_COLUMN_NAME;
        this.columnToolTips[1] = TYPE_COLUMN_DESCR;
        this.columnNames[2] = FULL_TYPE_COLUMN_NAME;
        this.columnToolTips[2] = FULL_TYPE_COLUMN_DESCR;
        this.columnNames[3] = VALUE_COLUMN_NAME;
        this.columnToolTips[3] = VALUE_COLUMN_DESCR;
        int n = this.getFontMetrics(this.getFont()).charWidth('W');
        FieldTreeCellRenderer fieldTreeCellRenderer = new FieldTreeCellRenderer();
        fieldTreeCellRenderer.setLeafIcon(null);
        fieldTreeCellRenderer.setClosedIcon(null);
        fieldTreeCellRenderer.setOpenIcon(null);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n * 18;
        this.columnRenderers[1] = labelTableCellRenderer;
        this.columnWidths[1] = n * 28;
        this.columnRenderers[2] = labelTableCellRenderer;
        this.columnWidths[2] = n * 14;
        this.columnRenderers[3] = labelTableCellRenderer;
    }

    private void initComponents() {
        this.treeCellRenderer.setLeafIcon(null);
        this.treeCellRenderer.setClosedIcon(null);
        this.treeCellRenderer.setOpenIcon(null);
        this.fieldsListTableModel.setRealColumnVisibility(2, false);
        this.fieldsListTable = new JTreeTable((AbstractTreeTableModel)this.fieldsListTableModel){

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < FieldsBrowserControllerUI.this.fieldsListTableModel.getColumnCount(); ++i) {
                    if (FieldsBrowserControllerUI.this.fieldsListTableModel.getRealColumn(i) == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(this.getWidth() - n);
                }
                super.doLayout();
            }
        };
        this.fieldsListTable.setSelectionMode(0);
        this.fieldsListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.fieldsListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.fieldsListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.fieldsListTable.setShowHorizontalLines(false);
        this.fieldsListTable.setShowVerticalLines(true);
        this.fieldsListTable.setRowMargin(0);
        this.fieldsListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.fieldsListTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.fieldsListTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.fieldsListTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FieldsBrowserControllerUI.this.performDefaultAction();
            }
        });
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>(this.fieldsListTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.fieldsListTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet(this.fieldsListTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.fieldsListTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JTreeTablePanel jTreeTablePanel = new JTreeTablePanel(this.fieldsListTable);
        jTreeTablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.add((Component)jTreeTablePanel, "Center");
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hTMLTextArea = new HTMLTextArea();
        hTMLTextArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String string = this.fieldsBrowserController.getRootMode() == 0 ? MessageFormat.format(NO_INSTANCE_SELECTED_MSG, "<img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/instances.png'>") : MessageFormat.format(NO_CLASS_SELECTED_MSG, "<img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/classes.png'>");
        hTMLTextArea.setText(string);
        this.noDataPanel.add((Component)hTMLTextArea, "Center");
        this.contents = new CardLayout();
        this.setLayout(this.contents);
        this.add(this.noDataPanel, NO_DATA);
        this.add(this.dataPanel, DATA);
        this.fieldsListTable.addMouseListener((MouseListener)new FieldsListTableMouseListener());
        this.fieldsListTable.addKeyListener((KeyListener)new FieldsListTableKeyListener());
    }

    private void initData() {
        this.fieldsListTableModel.setRoot((Object)this.fieldsBrowserController.getFilteredSortedFields(this.filterValue, this.sortingColumn, this.sortingOrder));
        this.refreshView();
    }

    private void navigateToInstance(Instance instance) {
        this.fieldsBrowserController.navigateToInstance(instance);
    }

    private void performDefaultAction() {
        HeapWalkerNode heapWalkerNode;
        int n = this.fieldsListTable.getSelectedRow();
        if (n != -1 && !(heapWalkerNode = (HeapWalkerNode)this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent()).isRoot() && heapWalkerNode instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)heapWalkerNode).hasInstance()) {
            if (this.fieldsBrowserController.getRootMode() == 0) {
                this.fieldsBrowserController.createNavigationHistoryPoint();
            }
            HeapWalkerInstanceNode heapWalkerInstanceNode = (HeapWalkerInstanceNode)heapWalkerNode;
            this.fieldsBrowserController.navigateToInstance(heapWalkerInstanceNode.getInstance());
        }
    }

    private void saveColumnsData() {
        TableColumnModel tableColumnModel = this.fieldsListTable.getColumnModel();
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int n = this.fieldsListTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
    }

    private void showColumnSelectionPopup(JPopupMenu jPopupMenu, JButton jButton) {
        this.initColumnSelectorItems();
        jPopupMenu.show(jButton, jButton.getWidth() - jPopupMenu.getPreferredSize().width, jButton.getHeight());
    }

    private void showPopupMenu(int n, int n2, int n3) {
        HeapWalkerNode heapWalkerNode = (HeapWalkerNode)this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent();
        if (heapWalkerNode instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)heapWalkerNode).isLoop()) {
            this.showLoopOriginItem.setVisible(true);
        } else {
            this.showLoopOriginItem.setVisible(false);
        }
        if (heapWalkerNode.isRoot()) {
            this.showInstanceItem.setEnabled(false);
        } else {
            this.showInstanceItem.setEnabled(heapWalkerNode instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)heapWalkerNode).hasInstance());
        }
        this.showClassItem.setEnabled(heapWalkerNode instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)heapWalkerNode).hasInstance());
        if (n2 == -1 || n3 == -1) {
            Rectangle rectangle = this.fieldsListTable.getCellRect(n, 0, true);
            if (n2 == -1) {
                n2 = rectangle.x + rectangle.width / 2;
            }
            if (n3 == -1) {
                n3 = rectangle.y + rectangle.height / 2;
            }
        }
        this.tablePopup.show((Component)this.fieldsListTable, n2, n3);
    }

    private class FieldsListTreeTableModel
    extends AbstractTreeTableModel {
        private FieldsListTreeTableModel() {
            super((CCTNode)(FieldsBrowserControllerUI.this.fieldsBrowserController.getRootMode() == 0 ? FieldsBrowserController.EMPTY_INSTANCE_NODE : FieldsBrowserController.EMPTY_CLASS_NODE));
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            return FieldsBrowserControllerUI.this.columnNames[n];
        }

        public String getColumnToolTipText(int n) {
            return FieldsBrowserControllerUI.this.columnToolTips[n];
        }

        public boolean isLeaf(Object object) {
            return ((HeapWalkerNode)object).isLeaf();
        }

        public Object getValueAt(Object object, int n) {
            HeapWalkerNode heapWalkerNode = (HeapWalkerNode)object;
            switch (n) {
                case 0: {
                    return heapWalkerNode;
                }
                case 1: {
                    return heapWalkerNode.getSimpleType();
                }
                case 2: {
                    return heapWalkerNode.getType();
                }
                case 3: {
                    return heapWalkerNode.getValue();
                }
            }
            return null;
        }
    }

    private class FieldsListTableMouseListener
    extends MouseAdapter {
        private FieldsListTableMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = FieldsBrowserControllerUI.this.fieldsListTable.rowAtPoint(mouseEvent.getPoint());
            if (n != -1) {
                HeapWalkerNode heapWalkerNode = (HeapWalkerNode)FieldsBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent();
                if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
                    if (heapWalkerNode instanceof HeapWalkerInstanceNode) {
                        FieldsBrowserControllerUI.this.performDefaultAction();
                    }
                } else if (mouseEvent.getModifiers() == 4) {
                    FieldsBrowserControllerUI.this.showPopupMenu(n, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = FieldsBrowserControllerUI.this.fieldsListTable.rowAtPoint(mouseEvent.getPoint());
            if (n != -1 && mouseEvent.getModifiers() == 4) {
                FieldsBrowserControllerUI.this.fieldsListTable.setRowSelectionInterval(n, n);
            }
        }
    }

    private class FieldsListTableKeyListener
    extends KeyAdapter {
        private FieldsListTableKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = FieldsBrowserControllerUI.this.fieldsListTable.getSelectedRow()) != -1) {
                FieldsBrowserControllerUI.this.showPopupMenu(n, -1, -1);
            }
        }
    }
}

