/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.DialogDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class ProfilerProgressDisplayer
extends JPanel {
    private static final String PROGRESS_STRING = NbBundle.getMessage(ProfilerProgressDisplayer.class, (String)"ProgressDisplayer_ProgressString");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(ProfilerProgressDisplayer.class, (String)"ProgressDisplayer_CancelButtonText");
    private static final Object displayerLock = new Object();
    private static ProfilerProgressDisplayer defaultInstance;
    private Cancellable controller;
    private Dialog owner;
    private JButton cancelButton;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private boolean isOpened;

    private ProfilerProgressDisplayer() {
        this.initComponents();
    }

    public static ProfilerProgressDisplayer showProgress(String string) {
        return ProfilerProgressDisplayer.showProgress(string, null);
    }

    public static ProfilerProgressDisplayer showProgress(String string, Cancellable cancellable) {
        return ProfilerProgressDisplayer.showProgress(PROGRESS_STRING, string, cancellable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilerProgressDisplayer showProgress(String string, String string2, Cancellable cancellable) {
        Object object = displayerLock;
        synchronized (object) {
            final ProfilerProgressDisplayer profilerProgressDisplayer = ProfilerProgressDisplayer.getDefault();
            DialogDescriptor dialogDescriptor = profilerProgressDisplayer.createDialogDescriptor(string, string2, cancellable);
            final Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
            dialog.pack();
            profilerProgressDisplayer.setOwner(dialog);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    profilerProgressDisplayer.setOpened(true);
                    dialog.setVisible(true);
                }
            });
            return profilerProgressDisplayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() {
        Object object = displayerLock;
        synchronized (object) {
            return this.isOpened;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = displayerLock;
        synchronized (object) {
            if (this.owner != null) {
                this.owner.setVisible(false);
                this.owner.dispose();
            }
            this.cleanup();
        }
    }

    private static ProfilerProgressDisplayer getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilerProgressDisplayer();
        }
        return defaultInstance;
    }

    private void setOpened(boolean bl) {
        this.isOpened = bl;
    }

    private void setOwner(Dialog dialog) {
        this.owner = dialog;
        if (dialog instanceof JDialog) {
            ((JDialog)dialog).setDefaultCloseOperation(0);
        }
    }

    private void cleanup() {
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(false);
        }
        this.isOpened = false;
        this.controller = null;
        this.owner = null;
    }

    private DialogDescriptor createDialogDescriptor(String string, String string2, Cancellable cancellable) {
        this.controller = cancellable;
        this.progressLabel.setText(string2);
        this.progressBar.setIndeterminate(true);
        DialogDescriptor dialogDescriptor = null;
        dialogDescriptor = cancellable == null ? new DialogDescriptor((Object)this, string, true, new Object[0], null, 0, null, null) : new DialogDescriptor((Object)this, string, true, new Object[]{this.cancelButton}, null, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[0]);
        return dialogDescriptor;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.progressLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 8, 0, 8);
        this.add((Component)this.progressLabel, gridBagConstraints);
        this.progressBar = new JProgressBar(0);
        this.progressBar.setPreferredSize(new Dimension(300, this.progressBar.getPreferredSize().height));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 8, 15, 8);
        this.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Utils.createFillerPanel(), gridBagConstraints);
        this.cancelButton = new JButton(CANCEL_BUTTON_TEXT);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProfilerProgressDisplayer.this.controller != null) {
                    ProfilerProgressDisplayer.this.controller.cancel();
                }
            }
        });
    }
}

