/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.JAASCallbackHandler;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;

public class JAASRealm
extends RealmBase {
    protected String appName = "Tomcat";
    protected static final String info = "org.apache.catalina.realm.JAASRealm/1.0";
    protected static final String name = "JAASRealm";
    protected ArrayList roleClasses = new ArrayList();
    protected static final StringManager sm;
    protected ArrayList userClasses = new ArrayList();
    protected String roleClassNames = null;
    protected String userClassNames = null;

    public void setAppName(String name) {
        this.appName = name;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRoleClassNames() {
        return this.roleClassNames;
    }

    public void setRoleClassNames(String roleClassNames) {
        int comma;
        this.roleClassNames = roleClassNames;
        this.roleClasses.clear();
        String temp = this.roleClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.roleClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.roleClasses.add(temp);
        }
    }

    public String getUserClassNames() {
        return this.userClassNames;
    }

    public void setUserClassNames(String userClassNames) {
        int comma;
        this.userClassNames = userClassNames;
        this.userClasses.clear();
        String temp = this.userClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.userClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.userClasses.add(temp);
        }
    }

    public Principal authenticate(String username, String credentials) {
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(this.appName, new JAASCallbackHandler(this, username, credentials));
        }
        catch (LoginException e) {
            this.log(sm.getString("jaasRealm.loginException", username), e);
            return null;
        }
        Subject subject = null;
        try {
            loginContext.login();
            subject = loginContext.getSubject();
            if (subject == null) {
                if (this.debug >= 2) {
                    this.log(sm.getString("jaasRealm.failedLogin", username));
                }
                return null;
            }
        }
        catch (AccountExpiredException e) {
            if (this.debug >= 2) {
                this.log(sm.getString("jaasRealm.accountExpired", username));
            }
            return null;
        }
        catch (CredentialExpiredException e) {
            if (this.debug >= 2) {
                this.log(sm.getString("jaasRealm.credentialExpired", username));
            }
            return null;
        }
        catch (FailedLoginException e) {
            if (this.debug >= 2) {
                this.log(sm.getString("jaasRealm.failedLogin", username));
            }
            return null;
        }
        catch (LoginException e) {
            this.log(sm.getString("jaasRealm.loginException", username), e);
            return null;
        }
        Principal principal = this.createPrincipal(subject);
        if (principal == null) {
            this.log(sm.getString("jaasRealm.authenticateError", username));
            return null;
        }
        if (this.debug >= 2) {
            this.log(sm.getString("jaasRealm.authenticateSuccess", username));
        }
        return principal;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    protected Principal createPrincipal(Subject subject) {
        String username = null;
        String password = null;
        ArrayList<String> roles = new ArrayList<String>();
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal principal = principals.next();
            String principalClass = principal.getClass().getName();
            if (username == null && this.userClasses.contains(principalClass)) {
                username = principal.getName();
            }
            if (!this.roleClasses.contains(principalClass)) continue;
            roles.add(principal.getName());
        }
        if (username != null) {
            return new GenericPrincipal(this, username, password, roles);
        }
        return null;
    }

    public void start() throws LifecycleException {
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
    }

    static {
        info = info;
        name = name;
        sm = StringManager.getManager("org.apache.catalina.realm");
    }
}

