/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.ReplicationWrapper;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;

public final class DistributedManager
extends PersistentManagerBase {
    private static final String info = "DistributedManager/1.0";
    protected static String name;
    private ClusterSender clusterSender = null;
    private ClusterReceiver clusterReceiver = null;

    public String getInfo() {
        return info;
    }

    public String getName() {
        return name;
    }

    public Session createSession() {
        Session session = super.createSession();
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        Object bis = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            ((StandardSession)session).writeObjectData(oos);
            oos.close();
            byte[] obs = bos.toByteArray();
            this.clusterSender.send(obs);
            if (this.debug > 0) {
                this.log("Replicating Session: " + session.getId());
            }
        }
        catch (IOException e) {
            this.log("An error occurred when replicating Session: " + session.getId());
        }
        return session;
    }

    public void start() throws LifecycleException {
        Container container = this.getContainer();
        Cluster cluster = null;
        if (container != null) {
            cluster = container.getCluster();
        }
        if (cluster != null) {
            this.clusterSender = cluster.getClusterSender(this.getName());
            this.clusterReceiver = cluster.getClusterReceiver(this.getName());
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processClusterReceiver() {
        objs = this.clusterReceiver.getObjects();
        _session = null;
        bis = null;
        loader = null;
        classLoader = null;
        ois = null;
        buf = new byte[5000];
        repObj = null;
        i = 0;
        while (i < objs.length) {
            block18: {
                try {
                    block17: {
                        bis = new ByteArrayInputStream(buf);
                        repObj = (ReplicationWrapper)objs[i];
                        buf = repObj.getDataStream();
                        bis = new ByteArrayInputStream(buf, 0, buf.length);
                        if (this.container != null) {
                            loader = this.container.getLoader();
                        }
                        if (loader != null) {
                            classLoader = loader.getClassLoader();
                        }
                        ois = classLoader != null ? new CustomObjectInputStream(bis, classLoader) : new ObjectInputStream(bis);
                        _session = (StandardSession)super.createSession();
                        _session.readObjectData(ois);
                        _session.setManager(this);
                        if (this.debug <= 0) break block17;
                        this.log("Loading replicated session: " + _session.getId());
                    }
                    var13_12 = null;
                    ** if (ois == null) goto lbl-1000
                }
                catch (Throwable var12_14) {
                    var13_12 = null;
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw var12_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block18;
                    catch (IOException e) {
                        this.log("Error occurred when trying to read replicated session: " + e.toString());
                        var13_12 = null;
                        if (ois != null) {
                            try {
                                ois.close();
                                bis = null;
                            }
                            catch (IOException e) {}
                        }
                        break block18;
                    }
                    catch (ClassNotFoundException e) {
                        this.log("Error occurred when trying to read replicated session: " + e.toString());
                        var13_12 = null;
                        if (ois != null) {
                            try {
                                ois.close();
                                bis = null;
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processClusterReceiver();
            this.processExpires();
            this.processPersistenceChecks();
        }
    }

    static {
        info = info;
        name = "DistributedManager";
    }
}

