/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;

public class JDBCStore
extends StoreBase
implements Store {
    protected static String info = "JDBCStore/1.0";
    protected static String storeName = "JDBCStore";
    protected String threadName = "JDBCStore";
    protected String connString = null;
    private Connection conn = null;
    protected String driverName = null;
    protected String sessionTable = "tomcat$sessions";
    protected String sessionIdCol = "id";
    protected String sessionDataCol = "data";
    protected String sessionValidCol = "valid";
    protected String sessionMaxInactiveCol = "maxinactive";
    protected String sessionLastAccessedCol = "lastaccess";
    protected PreparedStatement preparedSizeSql = null;
    protected PreparedStatement preparedKeysSql = null;
    protected PreparedStatement preparedSaveSql = null;
    protected PreparedStatement preparedClearSql = null;
    protected PreparedStatement preparedRemoveSql = null;
    protected PreparedStatement preparedLoadSql = null;

    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setDriverName(String driverName) {
        String oldDriverName = this.driverName;
        this.driverName = driverName;
        this.support.firePropertyChange("driverName", oldDriverName, this.driverName);
        this.driverName = driverName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setConnectionURL(String connectionURL) {
        String oldConnString = this.connString;
        this.connString = connectionURL;
        this.support.firePropertyChange("connString", oldConnString, this.connString);
    }

    public String getConnectionURL() {
        return this.connString;
    }

    public void setSessionTable(String sessionTable) {
        String oldSessionTable = this.sessionTable;
        this.sessionTable = sessionTable;
        this.support.firePropertyChange("sessionTable", oldSessionTable, this.sessionTable);
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionIdCol(String sessionIdCol) {
        String oldSessionIdCol = this.sessionIdCol;
        this.sessionIdCol = sessionIdCol;
        this.support.firePropertyChange("sessionIdCol", oldSessionIdCol, this.sessionIdCol);
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionDataCol(String sessionDataCol) {
        String oldSessionDataCol = this.sessionDataCol;
        this.sessionDataCol = sessionDataCol;
        this.support.firePropertyChange("sessionDataCol", oldSessionDataCol, this.sessionDataCol);
    }

    public String getSessionDataCol() {
        return this.sessionDataCol;
    }

    public void setSessionValidCol(String sessionValidCol) {
        String oldSessionValidCol = this.sessionValidCol;
        this.sessionValidCol = sessionValidCol;
        this.support.firePropertyChange("sessionValidCol", oldSessionValidCol, this.sessionValidCol);
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionMaxInactiveCol(String sessionMaxInactiveCol) {
        String oldSessionMaxInactiveCol = this.sessionMaxInactiveCol;
        this.sessionMaxInactiveCol = sessionMaxInactiveCol;
        this.support.firePropertyChange("sessionMaxInactiveCol", oldSessionMaxInactiveCol, this.sessionMaxInactiveCol);
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionLastAccessedCol(String sessionLastAccessedCol) {
        String oldSessionLastAccessedCol = this.sessionLastAccessedCol;
        this.sessionLastAccessedCol = sessionLastAccessedCol;
        this.support.firePropertyChange("sessionLastAccessedCol", oldSessionLastAccessedCol, this.sessionLastAccessedCol);
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] keys() throws IOException {
        String[] keys;
        block17: {
            ResultSet rst;
            Connection _conn;
            block15: {
                String keysSql = "SELECT COUNT(s." + this.sessionIdCol + "), c." + this.sessionIdCol + " FROM " + this.sessionTable + " s, " + this.sessionTable + " c" + " GROUP BY c." + this.sessionIdCol;
                _conn = this.getConnection();
                rst = null;
                keys = null;
                if (_conn == null) {
                    return new String[0];
                }
                if (this.preparedKeysSql == null) {
                    this.preparedKeysSql = _conn.prepareStatement(keysSql);
                }
                if ((rst = this.preparedKeysSql.executeQuery()) != null && rst.next()) {
                    keys = new String[rst.getInt(1)];
                    keys[0] = rst.getString(2);
                    int i = 1;
                    while (rst.next()) {
                        keys[i++] = rst.getString(2);
                    }
                    break block15;
                }
                keys = new String[]{};
            }
            Object var8_6 = null;
            try {
                if (rst != null) {
                    rst.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            this.release(_conn);
            _conn = null;
            {
                break block17;
                catch (SQLException e) {
                    this.log(this.sm.getString(this.getStoreName() + ".SQLException", e));
                    Object var8_7 = null;
                    try {
                        if (rst != null) {
                            rst.close();
                        }
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    this.release(_conn);
                    _conn = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (rst != null) {
                        rst.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                this.release(_conn);
                _conn = null;
                throw throwable;
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getSize() throws IOException {
        int size;
        block15: {
            ResultSet rst;
            Connection _conn;
            block13: {
                size = 0;
                String sizeSql = "SELECT COUNT(" + this.sessionIdCol + ") FROM ".concat(this.sessionTable);
                _conn = this.getConnection();
                rst = null;
                if (_conn == null) {
                    return size;
                }
                if (this.preparedSizeSql == null) {
                    this.preparedSizeSql = _conn.prepareStatement(sizeSql);
                }
                if (!(rst = this.preparedSizeSql.executeQuery()).next()) break block13;
                size = rst.getInt(1);
            }
            Object var7_5 = null;
            try {
                if (rst != null) {
                    rst.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            this.release(_conn);
            _conn = null;
            {
                break block15;
                catch (SQLException e) {
                    this.log(this.sm.getString(this.getStoreName() + ".SQLException", e));
                    Object var7_6 = null;
                    try {
                        if (rst != null) {
                            rst.close();
                        }
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    this.release(_conn);
                    _conn = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (rst != null) {
                        rst.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                this.release(_conn);
                _conn = null;
                throw throwable;
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Session load(String id) throws ClassNotFoundException, IOException {
        block27: {
            block25: {
                rst = null;
                _conn = this.getConnection();
                _session = null;
                loader = null;
                classLoader = null;
                ois = null;
                bis = null;
                container = this.manager.getContainer();
                loadSql = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?";
                if (_conn == null) {
                    return null;
                }
                if (this.preparedLoadSql == null) {
                    this.preparedLoadSql = _conn.prepareStatement(loadSql);
                }
                this.preparedLoadSql.setString(1, id);
                rst = this.preparedLoadSql.executeQuery();
                if (rst.next()) {
                    bis = new BufferedInputStream(rst.getBinaryStream(2));
                    if (container != null) {
                        loader = container.getLoader();
                    }
                    if (loader != null) {
                        classLoader = loader.getClassLoader();
                    }
                    ois = classLoader != null ? new CustomObjectInputStream(bis, classLoader) : new ObjectInputStream(bis);
                    break block25;
                }
                if (this.debug <= 0) break block25;
                this.log(this.getStoreName() + ": No persisted data object found");
            }
            var13_11 = null;
            try {
                if (rst != null) {
                    rst.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.release(_conn);
            _conn = null;
            {
                break block27;
                catch (SQLException e) {
                    this.log(this.sm.getString(this.getStoreName() + ".SQLException", e));
                    var13_12 = null;
                    try {
                        if (rst != null) {
                            rst.close();
                        }
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.release(_conn);
                    _conn = null;
                }
            }
            catch (Throwable var12_18) {
                var13_13 = null;
                try {
                    if (rst != null) {
                        rst.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.release(_conn);
                _conn = null;
                throw var12_18;
            }
        }
        if (ois != null) {
            try {
                _session = (StandardSession)this.manager.createSession();
                _session.readObjectData(ois);
                _session.setManager(this.manager);
                var16_19 = null;
                ** if (ois == null) goto lbl-1000
            }
            catch (Throwable var15_23) {
                var16_20 = null;
                if (ois != null) {
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var15_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    ois.close();
                    bis = null;
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
            }
            if (this.debug > 0) {
                this.log(this.sm.getString(this.getStoreName() + ".loading", id, this.sessionTable));
            }
        }
        return _session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) throws IOException {
        Connection _conn = this.getConnection();
        String removeSql = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?";
        if (_conn == null) {
            return;
        }
        try {
            try {
                if (this.preparedRemoveSql == null) {
                    this.preparedRemoveSql = _conn.prepareStatement(removeSql);
                }
                this.preparedRemoveSql.setString(1, id);
                this.preparedRemoveSql.execute();
            }
            catch (SQLException e) {
                this.log(this.sm.getString(this.getStoreName() + ".SQLException", e));
                Object var6_5 = null;
                this.release(_conn);
                _conn = null;
            }
            Object var6_4 = null;
            this.release(_conn);
            _conn = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.release(_conn);
            _conn = null;
            throw throwable;
        }
        if (this.debug > 0) {
            this.log(this.sm.getString(this.getStoreName() + ".removing", id, this.sessionTable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Connection _conn = this.getConnection();
        String clearSql = "DELETE FROM ".concat(this.sessionTable);
        if (_conn == null) {
            return;
        }
        try {
            try {
                if (this.preparedClearSql == null) {
                    this.preparedClearSql = _conn.prepareStatement(clearSql);
                }
                this.preparedClearSql.execute();
            }
            catch (SQLException e) {
                this.log(this.sm.getString(this.getStoreName() + ".SQLException", e));
                Object var5_4 = null;
                this.release(_conn);
                _conn = null;
            }
            Object var5_3 = null;
            this.release(_conn);
            _conn = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.release(_conn);
            _conn = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Session session) throws IOException {
        block15: {
            InputStream in;
            ByteArrayInputStream bis;
            ByteArrayOutputStream bos;
            ObjectOutputStream oos;
            Connection _conn;
            block16: {
                String saveSql = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?)";
                _conn = this.getConnection();
                oos = null;
                bos = null;
                bis = null;
                in = null;
                if (_conn == null) {
                    return;
                }
                this.remove(session.getId());
                try {
                    try {
                        bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(new BufferedOutputStream(bos));
                        ((StandardSession)session).writeObjectData(oos);
                        oos.close();
                        byte[] obs = bos.toByteArray();
                        int size = obs.length;
                        bis = new ByteArrayInputStream(obs, 0, size);
                        in = new BufferedInputStream(bis, size);
                        if (this.preparedSaveSql == null) {
                            this.preparedSaveSql = _conn.prepareStatement(saveSql);
                        }
                        this.preparedSaveSql.setString(1, session.getId());
                        this.preparedSaveSql.setBinaryStream(2, in, size);
                        this.preparedSaveSql.setString(3, session.isValid() ? "1" : "0");
                        this.preparedSaveSql.setInt(4, session.getMaxInactiveInterval());
                        this.preparedSaveSql.setLong(5, session.getLastAccessedTime());
                        this.preparedSaveSql.execute();
                    }
                    catch (SQLException e) {
                        this.log(this.sm.getString(this.getStoreName() + ".SQLException", e));
                        Object var11_13 = null;
                        if (bis != null) {
                            bis.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        bis = null;
                        bos = null;
                        oos = null;
                        in = null;
                        this.release(_conn);
                        _conn = null;
                        break block15;
                    }
                    catch (IOException e) {
                        Object var11_14 = null;
                        if (bis != null) {
                            bis.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        bis = null;
                        bos = null;
                        oos = null;
                        in = null;
                        this.release(_conn);
                        _conn = null;
                        break block15;
                    }
                    Object var11_12 = null;
                    if (bis == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    if (bis != null) {
                        bis.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    bis = null;
                    bos = null;
                    oos = null;
                    in = null;
                    this.release(_conn);
                    _conn = null;
                    throw throwable;
                }
                bis.close();
            }
            if (in != null) {
                in.close();
            }
            bis = null;
            bos = null;
            oos = null;
            in = null;
            this.release(_conn);
            _conn = null;
        }
        if (this.debug > 0) {
            this.log(this.sm.getString(this.getStoreName() + ".saving", session.getId(), this.sessionTable));
        }
    }

    protected Connection getConnection() {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                Class.forName(this.driverName);
                this.log(this.sm.getString(this.getStoreName() + ".checkConnectionDBClosed"));
                this.conn = DriverManager.getConnection(this.connString);
                this.conn.setAutoCommit(true);
                if (this.conn == null || this.conn.isClosed()) {
                    this.log(this.sm.getString(this.getStoreName() + ".checkConnectionDBReOpenFail"));
                }
            }
        }
        catch (SQLException ex) {
            this.log(this.sm.getString(this.getStoreName() + ".checkConnectionSQLException", ex.toString()));
        }
        catch (ClassNotFoundException ex) {
            this.log(this.sm.getString(this.getStoreName() + ".checkConnectionClassNotFoundException", ex.toString()));
        }
        return this.conn;
    }

    protected void release(Connection conn) {
    }

    public void start() throws LifecycleException {
        super.start();
        this.conn = this.getConnection();
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.conn != null) {
            try {
                this.conn.commit();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.preparedSizeSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.preparedKeysSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.preparedSaveSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.preparedClearSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.preparedRemoveSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.preparedLoadSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.preparedSizeSql = null;
            this.preparedKeysSql = null;
            this.preparedSaveSql = null;
            this.preparedClearSql = null;
            this.preparedRemoveSql = null;
            this.preparedLoadSql = null;
            this.conn = null;
        }
    }
}

