/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class URLEncoder {
    protected static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected BitSet safeCharacters = new BitSet(256);

    public URLEncoder() {
        char i = 'a';
        while (i <= 'z') {
            this.addSafeCharacter(i);
            i = (char)(i + '\u0001');
        }
        char i2 = 'A';
        while (i2 <= 'Z') {
            this.addSafeCharacter(i2);
            i2 = (char)(i2 + '\u0001');
        }
        char i3 = '0';
        while (i3 <= '9') {
            this.addSafeCharacter(i3);
            i3 = (char)(i3 + '\u0001');
        }
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    public String encode(String path) {
        int maxBytesPerChar = 10;
        int caseDiff = 32;
        StringBuffer rewrittenPath = new StringBuffer(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        int i = 0;
        while (i < path.length()) {
            block8: {
                char c = path.charAt(i);
                if (this.safeCharacters.get(c)) {
                    rewrittenPath.append(c);
                } else {
                    try {
                        writer.write(c);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block8;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        byte toEncode = ba[j];
                        rewrittenPath.append('%');
                        int low = toEncode & 0xF;
                        int high = (toEncode & 0xF0) >> 4;
                        rewrittenPath.append(hexadecimal[high]);
                        rewrittenPath.append(hexadecimal[low]);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
        return rewrittenPath.toString();
    }
}

