/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvm;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OperatingSystemMXBean;
import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.jvm.JVMImpl;
import com.sun.tools.visualvm.jvm.MonitoredDataImpl;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeansFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.swing.Timer;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxSupport
implements DataRemovedListener {
    private static final Logger LOGGER = Logger.getLogger(JmxSupport.class.getName());
    private static final String HOTSPOT_DIAGNOSTIC_MXBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String PERM_GEN = "Perm Gen";
    private static final String PS_PERM_GEN = "PS Perm Gen";
    private static final String CMS_PERM_GEN = "CMS Perm Gen";
    private static final String IBM_PERM_GEN = "class storage";
    private Application application;
    private JvmMXBeans mxbeans;
    private JVMImpl jvm;
    private boolean hotspotDiagnosticInitialized;
    private Object hotspotDiagnosticLock = new Object();
    private HotSpotDiagnosticMXBean hotspotDiagnosticMXBean;
    private boolean operatingSystemMXBeanInitialized;
    private Object operatingSystemMXBeanLock = new Object();
    private OperatingSystemMXBean operatingSystemMXBean;
    private Timer timer;
    private MemoryPoolMXBean permGenPool;
    private Collection<GarbageCollectorMXBean> gcList;

    JmxSupport(Application app, JVMImpl vm) {
        this.jvm = vm;
        this.application = app;
        app.notifyWhenRemoved((DataRemovedListener)this);
    }

    RuntimeMXBean getRuntime() {
        JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            return jmx.getRuntimeMXBean();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperatingSystemMXBean getOperationSystem() {
        Object object = this.operatingSystemMXBeanLock;
        synchronized (object) {
            if (this.operatingSystemMXBeanInitialized) {
                return this.operatingSystemMXBean;
            }
            this.operatingSystemMXBeanInitialized = true;
            JvmMXBeans jmx = this.getJvmMXBeans();
            if (jmx != null) {
                try {
                    ObjectName osName = new ObjectName("java.lang:type=OperatingSystem");
                    this.operatingSystemMXBean = (OperatingSystemMXBean)jmx.getMXBean(osName, OperatingSystemMXBean.class);
                }
                catch (Exception ex) {
                    LOGGER.throwing(JmxSupport.class.getName(), "getOperationSystem", ex);
                    return null;
                }
            }
            return this.operatingSystemMXBean;
        }
    }

    synchronized JvmMXBeans getJvmMXBeans() {
        JmxModel jmxModel;
        if (this.mxbeans == null && (jmxModel = JmxModelFactory.getJmxModelFor((Application)this.application)) != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            this.mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel);
        }
        return this.mxbeans;
    }

    synchronized Collection<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        JvmMXBeans jmx;
        if (this.gcList == null && (jmx = this.getJvmMXBeans()) != null) {
            this.gcList = jmx.getGarbageCollectorMXBeans();
        }
        return this.gcList;
    }

    Properties getSystemProperties() {
        try {
            RuntimeMXBean runtime = this.getRuntime();
            if (runtime != null) {
                Properties prop = new Properties();
                prop.putAll(runtime.getSystemProperties());
                return prop;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.throwing(JmxSupport.class.getName(), "getSystemProperties", e);
            return null;
        }
    }

    String getJvmArgs() {
        try {
            RuntimeMXBean runtime = this.getRuntime();
            if (runtime != null) {
                StringBuilder buf = new StringBuilder();
                List<String> args = runtime.getInputArguments();
                for (String arg : args) {
                    buf.append(arg).append(' ');
                }
                return buf.toString();
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.throwing(JmxSupport.class.getName(), "getJvmArgs", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HotSpotDiagnosticMXBean getHotSpotDiagnostic() {
        Object object = this.hotspotDiagnosticLock;
        synchronized (object) {
            if (this.hotspotDiagnosticInitialized) {
                return this.hotspotDiagnosticMXBean;
            }
            JvmMXBeans jmx = this.getJvmMXBeans();
            if (jmx != null) {
                try {
                    this.hotspotDiagnosticMXBean = (HotSpotDiagnosticMXBean)jmx.getMXBean(ObjectName.getInstance(HOTSPOT_DIAGNOSTIC_MXBEAN_NAME), HotSpotDiagnosticMXBean.class);
                }
                catch (MalformedObjectNameException e) {
                    ErrorManager.getDefault().log(16, "Couldn't find HotSpotDiagnosticMXBean: " + e.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            this.hotspotDiagnosticInitialized = true;
            return this.hotspotDiagnosticMXBean;
        }
    }

    String takeThreadDump() {
        try {
            JvmMXBeans jmx = this.getJvmMXBeans();
            if (jmx == null) {
                return null;
            }
            RuntimeMXBean runtimeMXBean = this.getRuntime();
            ThreadMXBean threadMXBean = jmx.getThreadMXBean();
            if (runtimeMXBean == null || threadMXBean == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer(4096);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sb.append(df.format(new Date()) + "\n");
            sb.append("Full thread dump " + this.jvm.getVmName() + " (" + this.jvm.getVmVersion() + " " + this.jvm.getVmInfo() + "):\n");
            if (this.jvm.is15()) {
                long[] threadIds;
                for (long threadId : threadIds = threadMXBean.getAllThreadIds()) {
                    ThreadInfo thread = threadMXBean.getThreadInfo(threadId, Integer.MAX_VALUE);
                    if (thread == null) continue;
                    sb.append("\n\"" + thread.getThreadName() + "\" - Thread t@" + thread.getThreadId() + "\n");
                    sb.append("   java.lang.Thread.State: " + (Object)((Object)thread.getThreadState()));
                    if (thread.getLockName() != null) {
                        sb.append(" on " + thread.getLockName());
                        if (thread.getLockOwnerName() != null) {
                            sb.append(" owned by: " + thread.getLockOwnerName());
                        }
                    }
                    sb.append("\n");
                    for (StackTraceElement st : thread.getStackTrace()) {
                        sb.append("        at " + st.toString() + "\n");
                    }
                }
            } else {
                ThreadInfo[] threads;
                for (ThreadInfo thread : threads = threadMXBean.dumpAllThreads(true, true)) {
                    MonitorInfo[] monitors = null;
                    if (threadMXBean.isObjectMonitorUsageSupported()) {
                        monitors = thread.getLockedMonitors();
                    }
                    sb.append("\n\"" + thread.getThreadName() + "\" - Thread t@" + thread.getThreadId() + "\n");
                    sb.append("   java.lang.Thread.State: " + (Object)((Object)thread.getThreadState()));
                    if (thread.getLockName() != null) {
                        sb.append(" on " + thread.getLockName());
                        if (thread.getLockOwnerName() != null) {
                            sb.append(" owned by: " + thread.getLockOwnerName());
                        }
                    }
                    sb.append("\n");
                    int index = 0;
                    for (StackTraceElement st : thread.getStackTrace()) {
                        sb.append("\tat " + st.toString() + "\n");
                        if (monitors != null) {
                            for (MonitorInfo mi : monitors) {
                                if (mi.getLockedStackDepth() != index) continue;
                                sb.append("\t- locked " + mi.toString() + "\n");
                            }
                        }
                        ++index;
                    }
                    if (!threadMXBean.isSynchronizerUsageSupported()) continue;
                    sb.append("\n   Locked ownable synchronizers:");
                    LockInfo[] synchronizers = thread.getLockedSynchronizers();
                    if (synchronizers == null || synchronizers.length == 0) {
                        sb.append("\n\t- None\n");
                        continue;
                    }
                    for (LockInfo li : synchronizers) {
                        sb.append("\n\t- locked " + li.toString() + "\n");
                    }
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            LOGGER.throwing(JmxSupport.class.getName(), "takeThreadDump", e);
            return null;
        }
    }

    MemoryPoolMXBean getPermGenPool() {
        try {
            JvmMXBeans jmx;
            if (this.permGenPool == null && (jmx = this.getJvmMXBeans()) != null) {
                Collection pools = jmx.getMemoryPoolMXBeans();
                for (MemoryPoolMXBean pool : pools) {
                    MemoryType type = pool.getType();
                    String name = pool.getName();
                    if (!MemoryType.NON_HEAP.equals((Object)type) || !PERM_GEN.equals(name) && !PS_PERM_GEN.equals(name) && !CMS_PERM_GEN.equals(name) && !IBM_PERM_GEN.equals(name)) continue;
                    this.permGenPool = pool;
                    break;
                }
            }
            return this.permGenPool;
        }
        catch (Exception e) {
            LOGGER.throwing(JmxSupport.class.getName(), "getPermGenPool", e);
            return null;
        }
    }

    void initTimer() {
        int interval = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
        final JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            this.timer = new Timer(interval, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            try {
                                MonitoredDataImpl data = new MonitoredDataImpl((Jvm)JmxSupport.this.jvm, JmxSupport.this, jmx);
                                JmxSupport.this.jvm.notifyListeners(data);
                            }
                            catch (UndeclaredThrowableException e) {
                                LOGGER.throwing(JmxSupport.class.getName(), "MonitoredDataImpl<init>", e);
                            }
                        }
                    });
                }
            });
            this.timer.setCoalesce(true);
            this.timer.start();
        }
    }

    void disableTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void dataRemoved(Object dataSource) {
        this.disableTimer();
    }
}

