/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.views.monitor;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.application.jvm.MonitoredData;
import com.sun.tools.visualvm.application.jvm.MonitoredDataListener;
import com.sun.tools.visualvm.application.views.monitor.ChartsSupport;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.NotSupportedDisplayer;
import com.sun.tools.visualvm.heapdump.HeapDumpSupport;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeansFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.MemoryMXBean;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

class ApplicationMonitorView
extends DataSourceView {
    private static final Logger LOGGER = Logger.getLogger(ApplicationMonitorView.class.getName());
    private static final String IMAGE_PATH = "com/sun/tools/visualvm/application/views/resources/monitor.png";
    private Jvm jvm;
    private MemoryMXBean memoryMXBean;
    private MonitoredDataListener monitoredDataListener;

    public ApplicationMonitorView(Application application) {
        super((DataSource)application, NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Monitor"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 20, false);
    }

    protected void willBeAdded() {
        JvmMXBeans mxbeans;
        Application application = (Application)this.getDataSource();
        this.jvm = JvmFactory.getJVMFor((Application)application);
        this.memoryMXBean = null;
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && (mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel)) != null) {
            this.memoryMXBean = mxbeans.getMemoryMXBean();
        }
    }

    protected void removed() {
        if (this.jvm != null) {
            this.jvm.removeMonitoredDataListener(this.monitoredDataListener);
        }
    }

    protected DataViewComponent createComponent() {
        Application application = (Application)this.getDataSource();
        final MasterViewSupport masterViewSupport = new MasterViewSupport(application, this.jvm, this.memoryMXBean);
        DataViewComponent dvc = new DataViewComponent(masterViewSupport.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        final CpuViewSupport cpuViewSupport = new CpuViewSupport(application, this.jvm);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Cpu"), true), 1);
        dvc.addDetailsView(cpuViewSupport.getDetailsView(), 1);
        final HeapViewSupport heapViewSupport = new HeapViewSupport(this.jvm);
        final PermGenViewSupport permGenViewSupport = new PermGenViewSupport(this.jvm);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Memory"), true), 2);
        dvc.addDetailsView(heapViewSupport.getDetailsView(), 2);
        dvc.addDetailsView(permGenViewSupport.getDetailsView(), 2);
        final ClassesViewSupport classesViewSupport = new ClassesViewSupport(this.jvm);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Classes"), true), 3);
        dvc.addDetailsView(classesViewSupport.getDetailsView(), 3);
        final ThreadsViewSupport threadsViewSupport = new ThreadsViewSupport(this.jvm);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Threads"), true), 4);
        dvc.addDetailsView(threadsViewSupport.getDetailsView(), 4);
        this.monitoredDataListener = new MonitoredDataListener(){

            public void monitoredDataEvent(final MonitoredData data) {
                final long time = System.currentTimeMillis();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            masterViewSupport.refresh(data);
                            cpuViewSupport.refresh(data, time);
                            heapViewSupport.refresh(data, time);
                            permGenViewSupport.refresh(data, time);
                            classesViewSupport.refresh(data, time);
                            threadsViewSupport.refresh(data, time);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.INFO, "monitoredDataEvent", ex);
                        }
                    }
                });
            }
        };
        this.jvm.addMonitoredDataListener(this.monitoredDataListener);
        return dvc;
    }

    private static class ThreadsViewSupport
    extends JPanel {
        private boolean threadsMonitoringSupported;
        private ChartsSupport.Chart threadsMetricsChart;
        private HTMLLabel liveThreadsLabel;
        private HTMLLabel daemonThreadsLabel;
        private HTMLLabel liveThreadsPeakLabel;
        private HTMLLabel startedThreadsLabel;
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;
        private static final String LIVE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Live_threads");
        private static final String DAEMON = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Daemon_threads");
        private static final String PEAK = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Live_threads_peak");
        private static final String STARTED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Started_threads_total");

        public ThreadsViewSupport(Jvm jvm) {
            this.threadsMonitoringSupported = jvm.isThreadMonitoringSupported();
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Threads"), null, 10, (JComponent)this, null);
        }

        public void refresh(MonitoredData data, long time) {
            if (this.threadsMonitoringSupported) {
                long totalThreads = data.getThreadsLive();
                long daemonThreads = data.getThreadsDaemon();
                long peakThreads = data.getThreadsLivePeak();
                long startedThreads = data.getThreadsStarted();
                this.threadsMetricsChart.getModel().addItemValues(time, new long[]{totalThreads, daemonThreads});
                this.liveThreadsLabel.setText("<nobr><b>" + LIVE + ":</b> " + totalThreads + " </nobr>");
                this.daemonThreadsLabel.setText("<nobr><b>" + DAEMON + ":</b> " + daemonThreads + " </nobr>");
                this.liveThreadsPeakLabel.setText("<nobr><b>" + PEAK + ":</b> " + peakThreads + " </nobr>");
                this.startedThreadsLabel.setText("<nobr><b>" + STARTED + ":</b> " + startedThreads + " </nobr>");
                this.threadsMetricsChart.setToolTipText("<html><nobr><b>" + LIVE + ":</b> " + totalThreads + " </nobr>" + "<br>" + "<nobr><b>" + DAEMON + ":</b> " + daemonThreads + " </nobr>" + "<br>" + "<nobr><b>" + PEAK + ":</b> " + peakThreads + " </nobr>" + "<br>" + "<nobr><b>" + STARTED + ":</b> " + startedThreads + " </nobr></html>");
            }
        }

        private void initComponents() {
            Object contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.threadsMonitoringSupported) {
                this.liveThreadsLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.liveThreadsLabel.setText("<nobr><b>" + LIVE + ":</b></nobr>");
                this.liveThreadsLabel.setOpaque(false);
                this.daemonThreadsLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.daemonThreadsLabel.setText("<nobr><b>" + DAEMON + ":</b></nobr>");
                this.daemonThreadsLabel.setOpaque(false);
                this.liveThreadsPeakLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.liveThreadsPeakLabel.setText("<nobr><b>" + PEAK + ":</b></nobr>");
                this.liveThreadsPeakLabel.setOpaque(false);
                this.startedThreadsLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.startedThreadsLabel.setText("<nobr><b>" + STARTED + ":</b></nobr>");
                this.startedThreadsLabel.setOpaque(false);
                final JPanel threadsMetricsDataPanel = new JPanel(new GridLayout(2, 2));
                threadsMetricsDataPanel.setOpaque(false);
                threadsMetricsDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                threadsMetricsDataPanel.add((Component)this.liveThreadsLabel);
                threadsMetricsDataPanel.add((Component)this.liveThreadsPeakLabel);
                threadsMetricsDataPanel.add((Component)this.daemonThreadsLabel);
                threadsMetricsDataPanel.add((Component)this.startedThreadsLabel);
                this.threadsMetricsChart = new ChartsSupport.ThreadsMetricsChart();
                this.threadsMetricsChart.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), this.threadsMetricsChart.getBorder()));
                JPanel threadsMetricsLegendContainer = new JPanel(new FlowLayout(4));
                threadsMetricsLegendContainer.setOpaque(false);
                threadsMetricsLegendContainer.add(this.threadsMetricsChart.getBigLegendPanel());
                final JPanel threadsMetricsPanel = new JPanel(new BorderLayout());
                threadsMetricsPanel.setOpaque(true);
                threadsMetricsPanel.setBackground(Color.WHITE);
                threadsMetricsPanel.add((Component)threadsMetricsDataPanel, "North");
                threadsMetricsPanel.add((Component)((Object)this.threadsMetricsChart), "Center");
                threadsMetricsPanel.add((Component)threadsMetricsLegendContainer, "South");
                final boolean[] threadsMetricsPanelResizing = new boolean[]{false};
                threadsMetricsPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
                threadsMetricsPanel.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent e) {
                        boolean shouldBeVisible;
                        if (threadsMetricsPanelResizing[0]) {
                            threadsMetricsPanelResizing[0] = false;
                            return;
                        }
                        boolean bl = shouldBeVisible = threadsMetricsPanel.getSize().height > 275;
                        if (shouldBeVisible == threadsMetricsDataPanel.isVisible()) {
                            return;
                        }
                        threadsMetricsPanelResizing[0] = true;
                        threadsMetricsDataPanel.setVisible(shouldBeVisible);
                    }
                });
                contents = threadsMetricsPanel;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)contents, "Center");
        }
    }

    private static class ClassesViewSupport
    extends JPanel {
        private boolean classMonitoringSupported;
        private ChartsSupport.Chart classesMetricsChart;
        private HTMLLabel loadedClassesLabel;
        private HTMLLabel loadedSharedClassesLabel;
        private HTMLLabel unloadedClassesLabel;
        private HTMLLabel unloadedSharedClassesLabel;
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;
        private static final String TOTAL_LOADED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Total_loaded_classes");
        private static final String SHARED_LOADED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Shared_loaded_classes");
        private static final String TOTAL_UNLOADED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Total_unloaded_classes");
        private static final String SHARED_UNLOADED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Shared_unloaded_classes");

        public ClassesViewSupport(Jvm jvm) {
            this.classMonitoringSupported = jvm.isClassMonitoringSupported();
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Classes"), null, 10, (JComponent)this, null);
        }

        public void refresh(MonitoredData data, long time) {
            if (this.classMonitoringSupported) {
                long sharedUnloaded = data.getSharedUnloadedClasses();
                long totalUnloaded = data.getUnloadedClasses();
                long sharedClasses = data.getSharedLoadedClasses() - sharedUnloaded;
                long totalClasses = data.getLoadedClasses() - data.getUnloadedClasses() + sharedClasses;
                this.classesMetricsChart.getModel().addItemValues(time, new long[]{totalClasses, sharedClasses});
                this.loadedClassesLabel.setText("<nobr><b>" + TOTAL_LOADED + ":</b> " + totalClasses + " </nobr>");
                this.loadedSharedClassesLabel.setText("<nobr><b>" + SHARED_LOADED + ":</b> " + sharedClasses + " </nobr>");
                this.unloadedClassesLabel.setText("<nobr><b>" + TOTAL_UNLOADED + ":</b> " + totalUnloaded + " </nobr>");
                this.unloadedSharedClassesLabel.setText("<nobr><b>" + SHARED_UNLOADED + ":</b> " + sharedUnloaded + " </nobr>");
                this.classesMetricsChart.setToolTipText("<html><nobr><b>" + TOTAL_LOADED + ":</b> " + totalClasses + " </nobr>" + "<br>" + "<nobr><b>" + SHARED_LOADED + ":</b> " + sharedClasses + " </nobr>" + "<br>" + "<nobr><b>" + TOTAL_UNLOADED + ":</b> " + totalUnloaded + " </nobr>" + "<br>" + "<nobr><b>" + SHARED_UNLOADED + ":</b> " + sharedUnloaded + " </nobr></html>");
            }
        }

        private void initComponents() {
            Object contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.classMonitoringSupported) {
                this.loadedClassesLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.loadedClassesLabel.setText("<nobr><b>" + TOTAL_LOADED + ":</b></nobr>");
                this.loadedClassesLabel.setOpaque(false);
                this.loadedSharedClassesLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.loadedSharedClassesLabel.setText("<nobr><b>" + SHARED_LOADED + ":</b></nobr>");
                this.loadedSharedClassesLabel.setOpaque(false);
                this.unloadedClassesLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.unloadedClassesLabel.setText("<nobr><b>" + TOTAL_UNLOADED + ":</b></nobr>");
                this.unloadedClassesLabel.setOpaque(false);
                this.unloadedSharedClassesLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.unloadedSharedClassesLabel.setText("<nobr><b>" + SHARED_UNLOADED + ":</b></nobr>");
                this.unloadedSharedClassesLabel.setOpaque(false);
                final JPanel classesMetricsDataPanel = new JPanel(new GridLayout(2, 2));
                classesMetricsDataPanel.setOpaque(false);
                classesMetricsDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                classesMetricsDataPanel.add((Component)this.loadedClassesLabel);
                classesMetricsDataPanel.add((Component)this.unloadedClassesLabel);
                classesMetricsDataPanel.add((Component)this.loadedSharedClassesLabel);
                classesMetricsDataPanel.add((Component)this.unloadedSharedClassesLabel);
                this.classesMetricsChart = new ChartsSupport.ClassesMetricsChart();
                this.classesMetricsChart.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), this.classesMetricsChart.getBorder()));
                JPanel classesMetricsLegendContainer = new JPanel(new FlowLayout(4));
                classesMetricsLegendContainer.setOpaque(false);
                classesMetricsLegendContainer.add(this.classesMetricsChart.getBigLegendPanel());
                final JPanel classesMetricsPanel = new JPanel(new BorderLayout());
                classesMetricsPanel.setOpaque(true);
                classesMetricsPanel.setBackground(Color.WHITE);
                classesMetricsPanel.add((Component)classesMetricsDataPanel, "North");
                classesMetricsPanel.add((Component)((Object)this.classesMetricsChart), "Center");
                classesMetricsPanel.add((Component)classesMetricsLegendContainer, "South");
                final boolean[] classesMetricsPanelResizing = new boolean[]{false};
                classesMetricsPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
                classesMetricsPanel.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent e) {
                        boolean shouldBeVisible;
                        if (classesMetricsPanelResizing[0]) {
                            classesMetricsPanelResizing[0] = false;
                            return;
                        }
                        boolean bl = shouldBeVisible = classesMetricsPanel.getSize().height > 275;
                        if (shouldBeVisible == classesMetricsDataPanel.isVisible()) {
                            return;
                        }
                        classesMetricsPanelResizing[0] = true;
                        classesMetricsDataPanel.setVisible(shouldBeVisible);
                    }
                });
                contents = classesMetricsPanel;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)contents, "Center");
        }
    }

    private static class PermGenViewSupport
    extends JPanel {
        private boolean memoryMonitoringSupported;
        private ChartsSupport.Chart permgenMetricsChart;
        private HTMLLabel permHeapSizeLabel;
        private HTMLLabel permUsedHeapLabel;
        private HTMLLabel permMaxHeapLabel;
        private static final NumberFormat formatter = NumberFormat.getNumberInstance();
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;
        private static final String PERM_SIZE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_PermGen_size");
        private static final String USED_PERM = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Used_PermGen");
        private static final String MAX_PERM = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Max_PermGen_size");

        public PermGenViewSupport(Jvm jvm) {
            this.memoryMonitoringSupported = jvm.isMemoryMonitoringSupported();
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_PermGen"), null, 10, (JComponent)this, null);
        }

        public void refresh(MonitoredData data, long time) {
            if (this.memoryMonitoringSupported) {
                long permgenCapacity = data.getGenCapacity()[1];
                long permgenUsed = data.getGenUsed()[1];
                long permgenMax = data.getGenMaxCapacity()[1];
                this.permgenMetricsChart.getModel().addItemValues(time, new long[]{permgenCapacity, permgenUsed});
                this.permHeapSizeLabel.setText("<nobr><b>" + PERM_SIZE + ":</b> " + formatter.format(permgenCapacity) + " </nobr>");
                this.permUsedHeapLabel.setText("<nobr><b>" + USED_PERM + ":</b> " + formatter.format(permgenUsed) + " </nobr>");
                this.permMaxHeapLabel.setText("<nobr><b>" + MAX_PERM + ":</b> " + formatter.format(permgenMax) + " </nobr>");
                this.permgenMetricsChart.setToolTipText("<html><nobr><b>" + PERM_SIZE + ":</b> " + formatter.format(permgenCapacity) + " </nobr>" + "<br>" + "<nobr><b>" + USED_PERM + ":</b> " + formatter.format(permgenUsed) + " </nobr>" + "<br>" + "<nobr><b>" + MAX_PERM + ":</b> " + formatter.format(permgenMax) + " </nobr>");
            }
        }

        private void initComponents() {
            Object contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.memoryMonitoringSupported) {
                this.permHeapSizeLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.permHeapSizeLabel.setText("<nobr><b>" + PERM_SIZE + ":</b></nobr>");
                this.permHeapSizeLabel.setOpaque(false);
                this.permUsedHeapLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.permUsedHeapLabel.setText("<nobr><b>" + USED_PERM + ":</b></nobr>");
                this.permUsedHeapLabel.setOpaque(false);
                this.permMaxHeapLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.permMaxHeapLabel.setText("<nobr><b>" + MAX_PERM + ":</b></nobr>");
                this.permMaxHeapLabel.setOpaque(false);
                final JPanel permgenMetricsDataPanel = new JPanel(new GridLayout(2, 2));
                permgenMetricsDataPanel.setOpaque(false);
                permgenMetricsDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                permgenMetricsDataPanel.add((Component)this.permHeapSizeLabel);
                permgenMetricsDataPanel.add((Component)this.permMaxHeapLabel);
                permgenMetricsDataPanel.add((Component)this.permUsedHeapLabel);
                this.permgenMetricsChart = new ChartsSupport.PermGenMetricsChart();
                this.permgenMetricsChart.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), this.permgenMetricsChart.getBorder()));
                JPanel permgenMetricsLegendContainer = new JPanel(new FlowLayout(4));
                permgenMetricsLegendContainer.setOpaque(false);
                permgenMetricsLegendContainer.add(this.permgenMetricsChart.getBigLegendPanel());
                final JPanel permgenMetricsPanel = new JPanel(new BorderLayout());
                permgenMetricsPanel.setOpaque(true);
                permgenMetricsPanel.setBackground(Color.WHITE);
                permgenMetricsPanel.add((Component)permgenMetricsDataPanel, "North");
                permgenMetricsPanel.add((Component)((Object)this.permgenMetricsChart), "Center");
                permgenMetricsPanel.add((Component)permgenMetricsLegendContainer, "South");
                final boolean[] permgenMetricsPanelResizing = new boolean[]{false};
                permgenMetricsPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
                permgenMetricsPanel.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent e) {
                        boolean shouldBeVisible;
                        if (permgenMetricsPanelResizing[0]) {
                            permgenMetricsPanelResizing[0] = false;
                            return;
                        }
                        boolean bl = shouldBeVisible = permgenMetricsPanel.getSize().height > 275;
                        if (shouldBeVisible == permgenMetricsDataPanel.isVisible()) {
                            return;
                        }
                        permgenMetricsPanelResizing[0] = true;
                        permgenMetricsDataPanel.setVisible(shouldBeVisible);
                    }
                });
                contents = permgenMetricsPanel;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)contents, "Center");
        }
    }

    private static class HeapViewSupport
    extends JPanel {
        private boolean memoryMonitoringSupported;
        private ChartsSupport.Chart heapMetricsChart;
        private HTMLLabel heapSizeLabel;
        private HTMLLabel usedHeapLabel;
        private HTMLLabel maxHeapLabel;
        private static final NumberFormat formatter = NumberFormat.getNumberInstance();
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;
        private static final String HEAP_SIZE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Heap_size");
        private static final String USED_HEAP = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Used_heap");
        private static final String MAX_HEAP = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Max_Heap");

        public HeapViewSupport(Jvm jvm) {
            this.memoryMonitoringSupported = jvm.isMemoryMonitoringSupported();
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Heap"), null, 10, (JComponent)this, null);
        }

        public void refresh(MonitoredData data, long time) {
            if (this.memoryMonitoringSupported) {
                long heapCapacity = data.getGenCapacity()[0];
                long heapUsed = data.getGenUsed()[0];
                long maxHeap = data.getGenMaxCapacity()[0];
                this.heapMetricsChart.getModel().addItemValues(time, new long[]{heapCapacity, heapUsed});
                this.heapSizeLabel.setText("<nobr><b>" + HEAP_SIZE + ":</b> " + formatter.format(heapCapacity) + " </nobr>");
                this.usedHeapLabel.setText("<nobr><b>" + USED_HEAP + ":</b> " + formatter.format(heapUsed) + " </nobr>");
                this.maxHeapLabel.setText("<nobr><b>" + MAX_HEAP + ":</b> " + formatter.format(maxHeap) + " </nobr>");
                this.heapMetricsChart.setToolTipText("<html><nobr><b>" + HEAP_SIZE + ":</b> " + formatter.format(heapCapacity) + " </nobr>" + "<br>" + "<nobr><b>" + USED_HEAP + ":</b> " + formatter.format(heapUsed) + " </nobr>" + "<br>" + "<nobr><b>" + MAX_HEAP + ":</b> " + formatter.format(maxHeap) + " </nobr></html>");
            }
        }

        private void initComponents() {
            Object contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.memoryMonitoringSupported) {
                this.heapSizeLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.heapSizeLabel.setText("<nobr><b>" + HEAP_SIZE + ":</b></nobr>");
                this.heapSizeLabel.setOpaque(false);
                this.usedHeapLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.usedHeapLabel.setText("<nobr><b>" + USED_HEAP + ":</b></nobr>");
                this.usedHeapLabel.setOpaque(false);
                this.maxHeapLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.maxHeapLabel.setText("<nobr><b>" + MAX_HEAP + ":</b></nobr>");
                this.maxHeapLabel.setOpaque(false);
                final JPanel heapMetricsDataPanel = new JPanel(new GridLayout(2, 2));
                heapMetricsDataPanel.setOpaque(false);
                heapMetricsDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                heapMetricsDataPanel.add((Component)this.heapSizeLabel);
                heapMetricsDataPanel.add((Component)this.maxHeapLabel);
                heapMetricsDataPanel.add((Component)this.usedHeapLabel);
                this.heapMetricsChart = new ChartsSupport.HeapMetricsChart();
                this.heapMetricsChart.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), this.heapMetricsChart.getBorder()));
                JPanel heapMetricsLegendContainer = new JPanel(new FlowLayout(4));
                heapMetricsLegendContainer.setOpaque(false);
                heapMetricsLegendContainer.add(this.heapMetricsChart.getBigLegendPanel());
                final JPanel heapMetricsPanel = new JPanel(new BorderLayout());
                heapMetricsPanel.setOpaque(true);
                heapMetricsPanel.setBackground(Color.WHITE);
                heapMetricsPanel.add((Component)heapMetricsDataPanel, "North");
                heapMetricsPanel.add((Component)((Object)this.heapMetricsChart), "Center");
                heapMetricsPanel.add((Component)heapMetricsLegendContainer, "South");
                final boolean[] heapMetricsPanelResizing = new boolean[]{false};
                heapMetricsPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
                heapMetricsPanel.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent e) {
                        boolean shouldBeVisible;
                        if (heapMetricsPanelResizing[0]) {
                            heapMetricsPanelResizing[0] = false;
                            return;
                        }
                        boolean bl = shouldBeVisible = heapMetricsPanel.getSize().height > 275;
                        if (shouldBeVisible == heapMetricsDataPanel.isVisible()) {
                            return;
                        }
                        heapMetricsPanelResizing[0] = true;
                        heapMetricsDataPanel.setVisible(shouldBeVisible);
                    }
                });
                contents = heapMetricsPanel;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)contents, "Center");
        }
    }

    private static class CpuViewSupport
    extends JPanel {
        private boolean cpuMonitoringSupported;
        private boolean gcMonitoringSupported;
        private ChartsSupport.Chart cpuUsageChart;
        private HTMLLabel cpuLabel;
        private HTMLLabel gcLabel;
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;
        private static final String UNKNOWN = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Unknown");
        private static final String CPU = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Cpu");
        private static final String CPU_USAGE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Cpu_Usage");
        private static final String GC_USAGE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Gc_Usage");
        private long lastUpTime = -1L;
        private long lastProcessCpuTime = -1L;
        private long lastProcessGcTime = -1L;
        private int processors = 1;

        public CpuViewSupport(Application app, Jvm jvm) {
            this.cpuMonitoringSupported = jvm.isCpuMonitoringSupported();
            this.gcMonitoringSupported = jvm.isCollectionTimeSupported();
            if (this.cpuMonitoringSupported || this.gcMonitoringSupported) {
                JvmMXBeans mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)JmxModelFactory.getJmxModelFor((Application)app));
                this.processors = mxbeans.getOperatingSystemMXBean().getAvailableProcessors();
            }
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(CPU, null, 10, (JComponent)this, null);
        }

        public void refresh(MonitoredData data, long time) {
            if (this.cpuMonitoringSupported || this.gcMonitoringSupported) {
                boolean tracksProcessGcTime;
                long upTime = data.getUpTime() * 1000000L;
                long processCpuTime = this.cpuMonitoringSupported ? data.getProcessCpuTime() / (long)this.processors : -1L;
                long processGcTime = this.gcMonitoringSupported ? data.getCollectionTime() * 1000000L / (long)this.processors : -1L;
                boolean tracksProcessCpuTime = this.lastProcessCpuTime != -1L;
                boolean bl = tracksProcessGcTime = this.lastProcessGcTime != -1L;
                if (this.lastUpTime != -1L && (tracksProcessCpuTime || tracksProcessGcTime)) {
                    long upTimeDiff = upTime - this.lastUpTime;
                    long cpuUsage = -1L;
                    long gcUsage = -1L;
                    if (this.lastProcessCpuTime != -1L) {
                        long processTimeDiff = processCpuTime - this.lastProcessCpuTime;
                        cpuUsage = upTimeDiff > 0L ? Math.min((long)(100.0f * (float)processTimeDiff / (float)upTimeDiff), 100L) : 0L;
                        this.cpuLabel.setText("<nobr><b>" + CPU_USAGE + ":</b> " + cpuUsage + "% </nobr>");
                    }
                    if (this.lastProcessGcTime != -1L) {
                        long processGcTimeDiff = processGcTime - this.lastProcessGcTime;
                        long l = gcUsage = upTimeDiff > 0L ? Math.min((long)(100.0f * (float)processGcTimeDiff / (float)upTimeDiff), 100L) : 0L;
                        if (cpuUsage != -1L && cpuUsage < gcUsage) {
                            gcUsage = cpuUsage;
                        }
                        this.gcLabel.setText("<nobr><b>" + GC_USAGE + ":</b> " + gcUsage + "% </nobr>");
                    }
                    this.cpuUsageChart.getModel().addItemValues(time, new long[]{Math.max(cpuUsage, 0L), Math.max(gcUsage, 0L)});
                    String cpuUsageString = cpuUsage == -1L ? UNKNOWN : cpuUsage + "%";
                    String gcUsageString = gcUsage == -1L ? UNKNOWN : gcUsage + "%";
                    this.cpuUsageChart.setToolTipText("<html><nobr><b>" + CPU_USAGE + ":</b> " + cpuUsageString + " </nobr>" + "<br>" + "<html><nobr><b>" + GC_USAGE + ":</b> " + gcUsageString + " </nobr></html>");
                }
                this.lastUpTime = upTime;
                this.lastProcessCpuTime = processCpuTime;
                this.lastProcessGcTime = processGcTime;
            }
        }

        private void initComponents() {
            Object contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.cpuMonitoringSupported || this.gcMonitoringSupported) {
                this.cpuLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.cpuLabel.setText("<nobr><b>" + CPU_USAGE + ":</b> " + UNKNOWN + "</nobr>");
                this.cpuLabel.setOpaque(false);
                this.gcLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.gcLabel.setText("<nobr><b>" + GC_USAGE + ":</b> " + UNKNOWN + "</nobr>");
                this.gcLabel.setOpaque(false);
                final JPanel heapMetricsDataPanel = new JPanel(new GridLayout(2, 2));
                heapMetricsDataPanel.setOpaque(false);
                heapMetricsDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                heapMetricsDataPanel.add((Component)this.cpuLabel);
                heapMetricsDataPanel.add((Component)this.gcLabel);
                this.cpuUsageChart = new ChartsSupport.CpuMetricsChart();
                this.cpuUsageChart.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), this.cpuUsageChart.getBorder()));
                JPanel heapMetricsLegendContainer = new JPanel(new FlowLayout(4));
                heapMetricsLegendContainer.setOpaque(false);
                heapMetricsLegendContainer.add(this.cpuUsageChart.getBigLegendPanel());
                final JPanel heapMetricsPanel = new JPanel(new BorderLayout());
                heapMetricsPanel.setOpaque(true);
                heapMetricsPanel.setBackground(Color.WHITE);
                heapMetricsPanel.add((Component)heapMetricsDataPanel, "North");
                heapMetricsPanel.add((Component)((Object)this.cpuUsageChart), "Center");
                heapMetricsPanel.add((Component)heapMetricsLegendContainer, "South");
                final boolean[] heapMetricsPanelResizing = new boolean[]{false};
                heapMetricsPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
                heapMetricsPanel.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent e) {
                        boolean shouldBeVisible;
                        if (heapMetricsPanelResizing[0]) {
                            heapMetricsPanelResizing[0] = false;
                            return;
                        }
                        boolean bl = shouldBeVisible = heapMetricsPanel.getSize().height > 275;
                        if (shouldBeVisible == heapMetricsDataPanel.isVisible()) {
                            return;
                        }
                        heapMetricsPanelResizing[0] = true;
                        heapMetricsDataPanel.setVisible(shouldBeVisible);
                    }
                });
                contents = heapMetricsPanel;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)contents, "Center");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MasterViewSupport
    extends JPanel
    implements DataRemovedListener<Application>,
    PropertyChangeListener {
        private Application application;
        private Jvm jvm;
        private MemoryMXBean memoryMXBean;
        private HTMLTextArea area;
        private JButton gcButton;
        private JButton heapDumpButton;

        public MasterViewSupport(Application application, Jvm jvm, MemoryMXBean memoryMXBean) {
            this.application = application;
            this.jvm = jvm;
            this.memoryMXBean = memoryMXBean;
            this.initComponents();
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Monitor"), null, (JComponent)this);
        }

        public void refresh(MonitoredData data) {
            int selStart = this.area.getSelectionStart();
            int selEnd = this.area.getSelectionEnd();
            this.area.setText(this.getBasicTelemetry(data));
            this.area.select(selStart, selEnd);
        }

        public void dataRemoved(Application dataSource) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MasterViewSupport.this.gcButton.setEnabled(false);
                    MasterViewSupport.this.heapDumpButton.setEnabled(false);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.dataRemoved(this.application);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea(this.getBasicTelemetry(null));
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)this.area, "Center");
            this.gcButton = new JButton(new AbstractAction(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Perform_GC")){

                public void actionPerformed(ActionEvent e) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            try {
                                MasterViewSupport.this.memoryMXBean.gc();
                            }
                            catch (Exception e) {
                                LOGGER.throwing(ApplicationMonitorView.class.getName(), "initComponents", e);
                            }
                        }
                    });
                }
            });
            this.gcButton.setEnabled(this.memoryMXBean != null);
            this.heapDumpButton = new JButton(new AbstractAction(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Heap_Dump")){

                public void actionPerformed(ActionEvent e) {
                    HeapDumpSupport.getInstance().takeHeapDump(MasterViewSupport.this.application, (e.getModifiers() & 2) == 0);
                }
            });
            this.heapDumpButton.setEnabled(this.jvm.isTakeHeapDumpSupported());
            JPanel buttonsArea = new JPanel(new BorderLayout());
            buttonsArea.setOpaque(false);
            JPanel buttonsContainer = new JPanel(new BorderLayout(3, 0));
            buttonsContainer.setBackground(this.area.getBackground());
            buttonsContainer.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            buttonsContainer.add((Component)this.gcButton, "West");
            buttonsContainer.add((Component)this.heapDumpButton, "East");
            buttonsArea.add((Component)buttonsContainer, "North");
            this.add((Component)buttonsArea, "After");
            this.application.notifyWhenRemoved((DataRemovedListener)this);
            this.application.addPropertyChangeListener("prop_state", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.application));
        }

        private String getBasicTelemetry(MonitoredData data) {
            String uptimeLbl = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Uptime");
            if (data == null) {
                return "<nobr><b>" + uptimeLbl + ":</b></nobr>";
            }
            return "<nobr><b>" + uptimeLbl + ":</b> " + MasterViewSupport.getTime(data.getUpTime()) + "</nobr>";
        }

        public static String getTime(long millis) {
            long hours = millis / 3600000L;
            String sHours = hours == 0L ? "" : "" + hours + " hrs ";
            long minutes = (millis %= 3600000L) / 60000L;
            String sMinutes = (hours > 0L && minutes < 10L ? "0" + minutes : "" + minutes) + " min ";
            long seconds = (millis %= 60000L) / 1000L;
            String sSeconds = (seconds < 10L ? "0" + seconds : "" + seconds) + " sec";
            return sHours + sMinutes + sSeconds;
        }
    }
}

