/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.views.monitor;

import com.sun.tools.visualvm.application.views.monitor.BoundedDynamicXYChartModel;
import com.sun.tools.visualvm.core.options.GlobalPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChartModel;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.openide.util.NbBundle;

class ChartsSupport {
    public static final int MINIMUM_CHART_HEIGHT = 275;

    ChartsSupport() {
    }

    public static class PermGenMetricsChart
    extends Chart {
        protected void setupModel(BoundedDynamicXYChartModel xyChartModel) {
            xyChartModel.setupModel(new String[]{NbBundle.getMessage(ChartsSupport.class, (String)"LBL_PermGen_size"), NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Used_PermGen")}, new Color[]{new Color(255, 127, 127), new Color(127, 63, 191)});
        }

        protected SynchronousXYChart createChart() {
            SynchronousXYChart xyChart = new SynchronousXYChart(2, 50, 0.01);
            xyChart.setVerticalAxisValueDivider(0x100000);
            xyChart.setVerticalAxisValueString("M");
            xyChart.setTopChartMargin(20);
            xyChart.denySelection();
            xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
            return xyChart;
        }

        protected JPanel createBigLegend() {
            JLabel liveThreads = new JLabel(this.getModel().getSeriesName(0), (Icon)new ColorIcon(this.getModel().getSeriesColor(0), Color.BLACK, 18, 9), 10);
            liveThreads.setOpaque(false);
            liveThreads.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel daemonThreads = new JLabel(this.getModel().getSeriesName(1), (Icon)new ColorIcon(this.getModel().getSeriesColor(1), Color.BLACK, 18, 9), 10);
            daemonThreads.setOpaque(false);
            daemonThreads.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel legendPanel = new JPanel();
            legendPanel.setOpaque(false);
            legendPanel.add(liveThreads);
            legendPanel.add(daemonThreads);
            return legendPanel;
        }

        protected JPanel createSmallLegend() {
            return null;
        }
    }

    public static class HeapMetricsChart
    extends Chart {
        protected void setupModel(BoundedDynamicXYChartModel xyChartModel) {
            xyChartModel.setupModel(new String[]{NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Heap_size"), NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Used_heap")}, new Color[]{new Color(255, 127, 127), new Color(127, 63, 191)});
        }

        protected SynchronousXYChart createChart() {
            SynchronousXYChart xyChart = new SynchronousXYChart(2, 50, 0.01);
            xyChart.setVerticalAxisValueDivider(0x100000);
            xyChart.setVerticalAxisValueString("M");
            xyChart.setTopChartMargin(20);
            xyChart.denySelection();
            xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
            return xyChart;
        }

        protected JPanel createBigLegend() {
            JLabel liveThreads = new JLabel(this.getModel().getSeriesName(0), (Icon)new ColorIcon(this.getModel().getSeriesColor(0), Color.BLACK, 18, 9), 10);
            liveThreads.setOpaque(false);
            liveThreads.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel daemonThreads = new JLabel(this.getModel().getSeriesName(1), (Icon)new ColorIcon(this.getModel().getSeriesColor(1), Color.BLACK, 18, 9), 10);
            daemonThreads.setOpaque(false);
            daemonThreads.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel legendPanel = new JPanel();
            legendPanel.setOpaque(false);
            legendPanel.add(liveThreads);
            legendPanel.add(daemonThreads);
            return legendPanel;
        }

        protected JPanel createSmallLegend() {
            return null;
        }
    }

    public static class CpuMetricsChart
    extends Chart {
        protected BoundedDynamicXYChartModel createModel() {
            GlobalPreferences preferences = GlobalPreferences.sharedInstance();
            return new BoundedDynamicXYChartModel(preferences.getMonitoredDataCache() * 60 / preferences.getMonitoredDataPoll()){

                public long getMaxDisplayYValue(int seriesIndex) {
                    return 100L;
                }
            };
        }

        protected void setupModel(BoundedDynamicXYChartModel xyChartModel) {
            xyChartModel.setupModel(new String[]{NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Cpu_Usage"), NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Gc_Usage")}, new Color[]{new Color(255, 127, 127), new Color(127, 63, 191)});
        }

        protected SynchronousXYChart createChart() {
            return new SynchronousXYChart(1, 50, 0.01);
        }

        protected void setupChart(SynchronousXYChart xyChart) {
            super.setupChart(xyChart);
            long time = System.currentTimeMillis();
            xyChart.setVerticalAxisValueDivider(1);
            xyChart.setupInitialAppearance(time, time + 1200L, 0L, 100L);
            xyChart.setVerticalAxisValueString("%");
            xyChart.setTopChartMargin(5);
            xyChart.denySelection();
            xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
        }

        protected JPanel createBigLegend() {
            JLabel cpuUsage = new JLabel(this.getModel().getSeriesName(0), (Icon)new ColorIcon(this.getModel().getSeriesColor(0), Color.BLACK, 18, 9), 10);
            cpuUsage.setOpaque(false);
            cpuUsage.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel gcUsage = new JLabel(this.getModel().getSeriesName(1), (Icon)new ColorIcon(this.getModel().getSeriesColor(1), Color.BLACK, 18, 9), 10);
            gcUsage.setOpaque(false);
            gcUsage.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel legendPanel = new JPanel();
            legendPanel.setOpaque(false);
            legendPanel.add(cpuUsage);
            legendPanel.add(gcUsage);
            return legendPanel;
        }

        protected JPanel createSmallLegend() {
            return null;
        }
    }

    public static class ThreadsMetricsChart
    extends Chart {
        protected void setupModel(BoundedDynamicXYChartModel xyChartModel) {
            xyChartModel.setupModel(new String[]{NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Live_threads"), NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Daemon_threads")}, new Color[]{new Color(255, 127, 127), new Color(127, 63, 191)});
        }

        protected SynchronousXYChart createChart() {
            SynchronousXYChart xyChart = new SynchronousXYChart(1, 50, 0.01);
            xyChart.setTopChartMargin(20);
            xyChart.denySelection();
            xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
            return xyChart;
        }

        protected JPanel createBigLegend() {
            JLabel liveThreads = new JLabel(this.getModel().getSeriesName(0), (Icon)new ColorIcon(this.getModel().getSeriesColor(0), Color.BLACK, 18, 9), 10);
            liveThreads.setOpaque(false);
            liveThreads.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel daemonThreads = new JLabel(this.getModel().getSeriesName(1), (Icon)new ColorIcon(this.getModel().getSeriesColor(1), Color.BLACK, 18, 9), 10);
            daemonThreads.setOpaque(false);
            daemonThreads.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel legendPanel = new JPanel();
            legendPanel.setOpaque(false);
            legendPanel.add(liveThreads);
            legendPanel.add(daemonThreads);
            return legendPanel;
        }

        protected JPanel createSmallLegend() {
            return null;
        }
    }

    public static class ClassesMetricsChart
    extends Chart {
        protected void setupModel(BoundedDynamicXYChartModel xyChartModel) {
            xyChartModel.setupModel(new String[]{NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Total_loaded_classes"), NbBundle.getMessage(ChartsSupport.class, (String)"LBL_Shared_loaded_classes")}, new Color[]{new Color(255, 127, 127), new Color(127, 63, 191)});
        }

        protected SynchronousXYChart createChart() {
            SynchronousXYChart xyChart = new SynchronousXYChart(1, 50, 0.01);
            xyChart.setTopChartMargin(20);
            xyChart.denySelection();
            xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
            return xyChart;
        }

        protected JPanel createBigLegend() {
            JLabel totalClasses = new JLabel(this.getModel().getSeriesName(0), (Icon)new ColorIcon(this.getModel().getSeriesColor(0), Color.BLACK, 18, 9), 10);
            totalClasses.setOpaque(false);
            totalClasses.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel sharedClasses = new JLabel(this.getModel().getSeriesName(1), (Icon)new ColorIcon(this.getModel().getSeriesColor(1), Color.BLACK, 18, 9), 10);
            sharedClasses.setOpaque(false);
            sharedClasses.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel legendPanel = new JPanel();
            legendPanel.setOpaque(false);
            legendPanel.add(totalClasses);
            legendPanel.add(sharedClasses);
            return legendPanel;
        }

        protected JPanel createSmallLegend() {
            return null;
        }
    }

    public static abstract class Chart
    extends GraphPanel
    implements ChartModelListener {
        private SynchronousXYChart xyChart;
        private BoundedDynamicXYChartModel xyChartModel;
        private JPanel bigLegendPanel;
        private JPanel smallLegendPanel;

        public Chart() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.xyChartModel = this.createModel();
            this.setupModel(this.xyChartModel);
            this.xyChart = this.createChart();
            this.setupChart(this.xyChart);
            this.add((Component)this.xyChart, "Center");
            this.bigLegendPanel = this.createBigLegend();
            this.smallLegendPanel = this.createSmallLegend();
            ToolTipManager.sharedInstance().registerComponent((JComponent)this.xyChart);
        }

        protected BoundedDynamicXYChartModel createModel() {
            GlobalPreferences preferences = GlobalPreferences.sharedInstance();
            return new BoundedDynamicXYChartModel(preferences.getMonitoredDataCache() * 60 / preferences.getMonitoredDataPoll()){

                public long getMaxDisplayYValue(int seriesIndex) {
                    return this.getMaxYValue(0);
                }
            };
        }

        protected void setupChart(SynchronousXYChart xyChart) {
            long time = System.currentTimeMillis();
            xyChart.setBackgroundPaint((Paint)this.getBackground());
            xyChart.setModel((SynchronousXYChartModel)this.xyChartModel);
            xyChart.setFitToWindow();
            xyChart.setupInitialAppearance(time, time + 1200L, 0L, 2L);
        }

        protected abstract SynchronousXYChart createChart();

        protected abstract void setupModel(BoundedDynamicXYChartModel var1);

        protected abstract JPanel createBigLegend();

        protected abstract JPanel createSmallLegend();

        public SynchronousXYChart getChart() {
            return this.xyChart;
        }

        public BoundedDynamicXYChartModel getModel() {
            return this.xyChartModel;
        }

        public JPanel getBigLegendPanel() {
            return this.bigLegendPanel;
        }

        public JPanel getSmallLegendPanel() {
            return this.smallLegendPanel;
        }

        public void chartDataChanged() {
        }

        public void setToolTipText(String toolTipText) {
            super.setToolTipText(toolTipText);
            this.xyChart.setToolTipText(toolTipText);
        }
    }
}

