/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.views.overview;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.openide.util.NbBundle;

final class ApplicationOverviewModel {
    private static final String PROP_PREFIX = "ApplicationOverviewModel_";
    static final String SNAPSHOT_VERSION = "ApplicationOverviewModel_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    private static final String PROP_NOT_DEFINED = "<not defined>";
    public static final String PROP_BASIC_INFO_SUPPORTED = "ApplicationOverviewModel_basic_info_supported";
    public static final String PROP_SYSTEM_PROPERTIES_SUPPORTED = "ApplicationOverviewModel_system_properties_supported";
    public static final String PROP_PID = "ApplicationOverviewModel_pid";
    public static final String PROP_HOST_NAME = "ApplicationOverviewModel_host_name";
    public static final String PROP_MAIN_CLASS = "ApplicationOverviewModel_main_class";
    public static final String PROP_MAIN_ARGS = "ApplicationOverviewModel_main_args";
    public static final String PROP_VM_ID = "ApplicationOverviewModel_vm_id";
    public static final String PROP_JAVA_HOME = "ApplicationOverviewModel_java_home";
    public static final String PROP_JVM_FLAGS = "ApplicationOverviewModel_jvm_flags";
    public static final String PROP_OOME_ENABLED = "ApplicationOverviewModel_oome_enabled";
    public static final String PROP_JVM_ARGS = "ApplicationOverviewModel_jvm_args";
    public static final String PROP_SYSTEM_PROPERTIES = "ApplicationOverviewModel_system.properties";
    private boolean initialized;
    private DataSource source;
    private boolean basicInfoSupported;
    private boolean systemPropertiesSupported;
    private String pid;
    private String hostName;
    private String mainClass;
    private String mainArgs;
    private String vmId;
    private String javaHome;
    private String jvmFlags;
    private String oomeEnabled;
    private String jvmArgs;
    private String systemProperties;

    public static ApplicationOverviewModel create(Application application) {
        ApplicationOverviewModel model = new ApplicationOverviewModel();
        model.initialized = false;
        model.source = application;
        return model;
    }

    public static ApplicationOverviewModel create(Snapshot snapshot) {
        ApplicationOverviewModel model = new ApplicationOverviewModel();
        model.initialized = false;
        model.source = snapshot;
        return model;
    }

    public DataSource getSource() {
        return this.source;
    }

    public boolean basicInfoSupported() {
        return this.basicInfoSupported;
    }

    public boolean systemPropertiesSupported() {
        return this.systemPropertiesSupported;
    }

    public String getPid() {
        return this.pid;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMainArgs() {
        return this.mainArgs;
    }

    public String getVmId() {
        return this.vmId;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public String getJvmFlags() {
        return this.jvmFlags;
    }

    public String oomeEnabled() {
        if (this.basicInfoSupported() && this.source instanceof Application) {
            Jvm jvm = JvmFactory.getJVMFor((Application)((Application)this.source));
            this.oomeEnabled = jvm.isDumpOnOOMEnabled() ? NbBundle.getMessage(ApplicationOverviewModel.class, (String)"LBL_enabled") : NbBundle.getMessage(ApplicationOverviewModel.class, (String)"LBL_disabled");
        }
        return this.oomeEnabled;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public String getSystemProperties() {
        return this.systemProperties;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.source instanceof Application) {
            this.initialize((Application)this.source);
        } else {
            this.initialize((Snapshot)this.source);
        }
    }

    public void save(Snapshot snapshot) {
        this.initialize();
        Storage storage = snapshot.getStorage();
        ApplicationOverviewModel.setProperty(storage, SNAPSHOT_VERSION, CURRENT_SNAPSHOT_VERSION);
        ApplicationOverviewModel.setProperty(storage, PROP_BASIC_INFO_SUPPORTED, Boolean.toString(this.basicInfoSupported));
        ApplicationOverviewModel.setProperty(storage, PROP_SYSTEM_PROPERTIES_SUPPORTED, Boolean.toString(this.systemPropertiesSupported));
        ApplicationOverviewModel.setProperty(storage, PROP_PID, this.pid);
        ApplicationOverviewModel.setProperty(storage, PROP_HOST_NAME, this.hostName);
        ApplicationOverviewModel.setProperty(storage, PROP_MAIN_CLASS, this.mainClass);
        ApplicationOverviewModel.setProperty(storage, PROP_MAIN_ARGS, this.mainArgs);
        ApplicationOverviewModel.setProperty(storage, PROP_VM_ID, this.vmId);
        ApplicationOverviewModel.setProperty(storage, PROP_JAVA_HOME, this.javaHome);
        ApplicationOverviewModel.setProperty(storage, PROP_JVM_FLAGS, this.jvmFlags);
        ApplicationOverviewModel.setProperty(storage, PROP_OOME_ENABLED, this.oomeEnabled);
        ApplicationOverviewModel.setProperty(storage, PROP_JVM_ARGS, this.jvmArgs);
        ApplicationOverviewModel.setProperty(storage, PROP_SYSTEM_PROPERTIES, this.systemProperties);
    }

    private void initialize(Snapshot snapshot) {
        Storage storage = snapshot.getStorage();
        this.basicInfoSupported = Boolean.parseBoolean(ApplicationOverviewModel.getProperty(storage, PROP_BASIC_INFO_SUPPORTED));
        this.systemPropertiesSupported = Boolean.parseBoolean(ApplicationOverviewModel.getProperty(storage, PROP_SYSTEM_PROPERTIES_SUPPORTED));
        this.pid = ApplicationOverviewModel.getProperty(storage, PROP_PID);
        this.hostName = ApplicationOverviewModel.getProperty(storage, PROP_HOST_NAME);
        this.mainClass = ApplicationOverviewModel.getProperty(storage, PROP_MAIN_CLASS);
        this.mainArgs = ApplicationOverviewModel.getProperty(storage, PROP_MAIN_ARGS);
        this.vmId = ApplicationOverviewModel.getProperty(storage, PROP_VM_ID);
        this.javaHome = ApplicationOverviewModel.getProperty(storage, PROP_JAVA_HOME);
        this.jvmFlags = ApplicationOverviewModel.getProperty(storage, PROP_JVM_FLAGS);
        this.oomeEnabled = ApplicationOverviewModel.getProperty(storage, PROP_OOME_ENABLED);
        this.jvmArgs = ApplicationOverviewModel.getProperty(storage, PROP_JVM_ARGS);
        this.systemProperties = ApplicationOverviewModel.getProperty(storage, PROP_SYSTEM_PROPERTIES);
    }

    private static void setProperty(Storage storage, String property, String value) {
        storage.setCustomProperty(property, value == null ? PROP_NOT_DEFINED : value);
    }

    private static String getProperty(Storage storage, String property) {
        String value = storage.getCustomProperty(property);
        return PROP_NOT_DEFINED.equals(value) ? null : value;
    }

    private void initialize(Application application) {
        Properties jvmProperties;
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        this.source = application;
        this.basicInfoSupported = jvm.isBasicInfoSupported();
        this.systemPropertiesSupported = jvm.isGetSystemPropertiesSupported();
        int pidInt = application.getPid();
        this.pid = pidInt == -1 ? NbBundle.getMessage(ApplicationOverviewModel.class, (String)"LBL_unknown") : "" + pidInt;
        this.hostName = application.getHost().getHostName();
        if (this.basicInfoSupported) {
            this.mainClass = jvm.getMainClass();
            if (this.mainClass == null) {
                this.mainClass = NbBundle.getMessage(ApplicationOverviewModel.class, (String)"LBL_unknown");
            }
            this.mainArgs = jvm.getMainArgs();
            if (this.mainArgs == null) {
                this.mainArgs = NbBundle.getMessage(ApplicationOverviewModel.class, (String)"LBL_none");
            }
            this.vmId = jvm.getVmName() + " (" + jvm.getVmVersion() + ", " + jvm.getVmInfo() + ")";
            this.javaHome = jvm.getJavaHome();
            this.jvmFlags = jvm.getJvmFlags();
            if (this.jvmFlags == null || this.jvmFlags.length() == 0) {
                this.jvmFlags = NbBundle.getMessage(ApplicationOverviewModel.class, (String)"LBL_none");
            }
            this.oomeEnabled = jvm.isDumpOnOOMEnabled() ? NbBundle.getMessage(ApplicationOverviewModel.class, (String)"LBL_enabled") : NbBundle.getMessage(ApplicationOverviewModel.class, (String)"LBL_disabled");
            String jvmArgss = jvm.getJvmArgs();
            if (jvmArgss != null) {
                this.jvmArgs = ApplicationOverviewModel.formatJVMArgs(jvmArgss);
            }
        }
        if (this.systemPropertiesSupported && (jvmProperties = jvm.getSystemProperties()) != null) {
            this.systemProperties = ApplicationOverviewModel.formatSystemProperties(jvmProperties);
        }
    }

    private static String formatJVMArgs(String jvmargs) {
        String mangledString = " ".concat(jvmargs).replace(" -", "\n");
        StringTokenizer tok = new StringTokenizer(mangledString, "\n");
        StringBuffer text = new StringBuffer(100);
        while (tok.hasMoreTokens()) {
            String arg = tok.nextToken().replace(" ", "&nbsp;");
            int equalsSign = arg.indexOf(61);
            text.append("<b>");
            text.append("-");
            if (equalsSign != -1) {
                text.append(arg.substring(0, equalsSign));
                text.append("</b>");
                text.append(arg.substring(equalsSign));
            } else {
                text.append(arg);
                text.append("</b>");
            }
            text.append("<br>");
        }
        return text.toString();
    }

    private static String formatSystemProperties(Properties properties) {
        StringBuffer text = new StringBuffer(200);
        ArrayList keys = new ArrayList();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            keys.add(en.nextElement());
        }
        Collections.sort(keys);
        for (String key : keys) {
            String val = properties.getProperty(key);
            if ("line.separator".equals(key) && val != null) {
                val = val.replace("\n", "\\n");
                val = val.replace("\r", "\\r");
            }
            text.append("<b>");
            text.append(key);
            text.append("</b>=");
            text.append(val);
            text.append("<br>");
        }
        return text.toString();
    }

    private ApplicationOverviewModel() {
    }
}

