/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.jmx.application.ApplicationSecurityConfigurator;
import com.sun.tools.visualvm.jmx.application.JmxApplication;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModel;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModelFactory;
import com.sun.tools.visualvm.tools.jvmstat.JvmstatModel;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.openide.util.RequestProcessor;
import sun.rmi.server.UnicastRef2;
import sun.rmi.transport.LiveRef;

class JmxModelImpl
extends JmxModel {
    private static final String PROPERTY_USERNAME = "prop_username";
    private static final String PROPERTY_PASSWORD = "prop_password";
    private static final Logger LOGGER = Logger.getLogger(JmxModelImpl.class.getName());
    private ProxyClient client;
    private ApplicationRemovedListener removedListener;
    private ApplicationAvailabilityListener availabilityListener;

    public JmxModelImpl(Application application, JvmstatModel jvmstat) {
        try {
            JvmJvmstatModel jvmstatModel = JvmJvmstatModelFactory.getJvmstatModelFor((Application)application);
            ProxyClient proxyClient = null;
            if (Application.CURRENT_APPLICATION.equals((Object)application)) {
                proxyClient = new ProxyClient(this, "localhost", 0, null, null);
            } else if (application.isLocalApplication()) {
                String connectorAddress = jvmstat.findByName("sun.management.JMXConnectorServer.address");
                String javaHome = jvmstat.findByName("java.property.java.home");
                LocalVirtualMachine lvm = new LocalVirtualMachine(application.getPid(), jvmstatModel.isAttachable(), connectorAddress, javaHome);
                if (!lvm.isManageable()) {
                    if (lvm.isAttachable()) {
                        proxyClient = new ProxyClient(this, lvm);
                    } else if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("The JMX management agent cannot be enabled in this application (pid " + application.getPid() + ")");
                    }
                } else {
                    proxyClient = new ProxyClient(this, lvm);
                }
            } else {
                List urls = jvmstat.findByPattern("sun.management.JMXConnectorServer.[0-9]+.address");
                if (urls.size() != 0) {
                    List auths = jvmstat.findByPattern("sun.management.JMXConnectorServer.[0-9]+.authenticate");
                    proxyClient = new ProxyClient(this, (String)urls.get(0), null, null);
                    if ("true".equals(auths.get(0))) {
                        this.supplyCredentials(application, proxyClient);
                    }
                } else {
                    String jvmArgs = jvmstatModel.getJvmArgs();
                    StringTokenizer st = new StringTokenizer(jvmArgs);
                    int port = -1;
                    boolean authenticate = false;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (token.startsWith("-Dcom.sun.management.jmxremote.port=")) {
                            port = Integer.parseInt(token.substring(token.indexOf("=") + 1));
                            continue;
                        }
                        if (!token.equals("-Dcom.sun.management.jmxremote.authenticate=true")) continue;
                        authenticate = true;
                    }
                    if (port != -1) {
                        proxyClient = new ProxyClient(this, application.getHost().getHostName(), port, null, null);
                        if (authenticate) {
                            this.supplyCredentials(application, proxyClient);
                        }
                    }
                }
            }
            if (proxyClient != null) {
                this.client = proxyClient;
                this.removedListener = new ApplicationRemovedListener();
                this.availabilityListener = new ApplicationAvailabilityListener();
                this.connect(application, proxyClient, this.removedListener, this.availabilityListener);
            }
        }
        catch (Exception e) {
            LOGGER.throwing(JmxModelImpl.class.getName(), "<init>", e);
            this.client = null;
        }
    }

    public JmxModelImpl(JmxApplication application) {
        try {
            ProxyClient proxyClient;
            JMXServiceURL url = application.getJMXServiceURL();
            String username = application.getUsername();
            String password = application.getPassword();
            this.client = proxyClient = new ProxyClient(this, url.toString(), username, password);
            this.removedListener = new ApplicationRemovedListener();
            this.availabilityListener = new ApplicationAvailabilityListener();
            this.connect(application, proxyClient, this.removedListener, this.availabilityListener);
        }
        catch (Exception e) {
            LOGGER.throwing(JmxModelImpl.class.getName(), "<init>", e);
            this.client = null;
        }
    }

    private void connect(Application application, ProxyClient proxyClient, ApplicationRemovedListener listener, ApplicationAvailabilityListener aListener) {
        while (true) {
            try {
                proxyClient.connect();
                application.notifyWhenRemoved((DataRemovedListener)listener);
                application.addPropertyChangeListener("prop_state", (PropertyChangeListener)aListener);
            }
            catch (SecurityException e) {
                if (this.supplyCredentials(application, proxyClient) != null) continue;
            }
            break;
        }
    }

    private ApplicationSecurityConfigurator supplyCredentials(Application application, ProxyClient proxyClient) {
        ApplicationSecurityConfigurator jsc;
        String displayName = application.getStorage().getCustomProperty("prop_name");
        if (displayName == null) {
            displayName = proxyClient.getUrl().toString();
        }
        if ((jsc = ApplicationSecurityConfigurator.supplyCredentials(displayName)) != null) {
            proxyClient.setParameters(proxyClient.getUrl(), jsc.getUsername(), jsc.getPassword());
            if (application instanceof JmxApplication && ((JmxApplication)application).getSaveCredentialsFlag()) {
                Storage storage = application.getStorage();
                storage.setCustomProperty(PROPERTY_USERNAME, jsc.getUsername());
                storage.setCustomProperty(PROPERTY_PASSWORD, Utils.encodePassword((String)jsc.getPassword()));
            }
        }
        return jsc;
    }

    public JmxModel.ConnectionState getConnectionState() {
        if (this.client != null) {
            return this.client.getConnectionState();
        }
        return JmxModel.ConnectionState.DISCONNECTED;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        if (this.client != null) {
            return this.client.getMBeanServerConnection();
        }
        return null;
    }

    public JMXServiceURL getJMXServiceURL() {
        if (this.client != null) {
            return this.client.getUrl();
        }
        return null;
    }

    static class LocalVirtualMachine {
        private int vmid;
        private boolean isAttachSupported;
        private String javaHome;
        private volatile String address;
        private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";

        public LocalVirtualMachine(int vmid, boolean canAttach, String connectorAddress, String home) {
            this.vmid = vmid;
            this.address = connectorAddress;
            this.isAttachSupported = canAttach;
            this.javaHome = home;
        }

        public int vmid() {
            return this.vmid;
        }

        public synchronized boolean isManageable() {
            return this.address != null;
        }

        public boolean isAttachable() {
            return this.isAttachSupported;
        }

        public synchronized void startManagementAgent() throws IOException {
            if (this.address != null) {
                return;
            }
            if (!this.isAttachable()) {
                throw new IOException("This virtual machine \"" + this.vmid + "\" does not support dynamic attach.");
            }
            this.loadManagementAgent();
            if (this.address == null) {
                throw new IOException("Fails to find connector address");
            }
        }

        public synchronized String connectorAddress() {
            return this.address;
        }

        private synchronized void loadManagementAgent() throws IOException {
            VirtualMachine vm = null;
            String name = String.valueOf(this.vmid);
            try {
                vm = VirtualMachine.attach(name);
            }
            catch (AttachNotSupportedException x) {
                IOException ioe = new IOException(x.getMessage());
                ioe.initCause(x);
                throw ioe;
            }
            String agent = this.javaHome + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
            File f = new File(agent);
            if (!f.exists() && !(f = new File(agent = this.javaHome + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                throw new IOException("Management agent not found");
            }
            agent = f.getCanonicalPath();
            try {
                vm.loadAgent(agent, "com.sun.management.jmxremote");
            }
            catch (AgentLoadException x) {
                IOException ioe = new IOException(x.getMessage());
                ioe.initCause(x);
                throw ioe;
            }
            catch (AgentInitializationException x) {
                IOException ioe = new IOException(x.getMessage());
                ioe.initCause(x);
                throw ioe;
            }
            Properties agentProps = vm.getAgentProperties();
            this.address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
            vm.detach();
        }
    }

    static class CheckerInvocationHandler
    implements InvocationHandler {
        private final MBeanServerConnection conn;

        CheckerInvocationHandler(MBeanServerConnection conn) {
            this.conn = conn;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (LOGGER.isLoggable(Level.FINE) && EventQueue.isDispatchThread()) {
                Throwable thrwbl = new Throwable();
                LOGGER.log(Level.FINE, this.createTracedMessage("MBeanServerConnection call performed on Event Dispatch Thread!", thrwbl));
            }
            try {
                return method.invoke((Object)this.conn, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private String createTracedMessage(String message, Throwable thrwbl) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            pw.println(message);
            thrwbl.printStackTrace(pw);
            pw.flush();
            return baos.toString();
        }
    }

    static class Checker {
        private Checker() {
        }

        public static MBeanServerConnection newChecker(ProxyClient client, MBeanServerConnection mbsc) {
            CheckerInvocationHandler ih = new CheckerInvocationHandler(mbsc);
            return (MBeanServerConnection)Proxy.newProxyInstance(Checker.class.getClassLoader(), new Class[]{MBeanServerConnection.class}, (InvocationHandler)ih);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WeakPCL
    extends WeakReference<PropertyChangeListener>
    implements PropertyChangeListener {
        WeakPCL(PropertyChangeListener referent) {
            super(referent);
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            PropertyChangeListener pcl = (PropertyChangeListener)this.get();
            if (pcl == null) {
                this.dispose();
            } else {
                pcl.propertyChange(pce);
            }
        }

        private void dispose() {
            JmxModelImpl.this.removePropertyChangeListener(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProxyClient
    implements NotificationListener {
        private JmxModel.ConnectionState connectionState = JmxModel.ConnectionState.DISCONNECTED;
        private volatile boolean isDead = true;
        private String hostName = null;
        private int port = 0;
        private String userName = null;
        private String password = null;
        private LocalVirtualMachine lvm;
        private JMXServiceURL jmxUrl = null;
        private MBeanServerConnection conn = null;
        private JMXConnector jmxc = null;
        private RMIServer stub = null;
        private static final SslRMIClientSocketFactory sslRMIClientSocketFactory = new SslRMIClientSocketFactory();
        private String registryHostName = null;
        private int registryPort = 0;
        private boolean vmConnector = false;
        private boolean sslRegistry = false;
        private boolean sslStub = false;
        private final String connectionName;
        private final String displayName;
        private final JmxModelImpl model;
        private static final String rmiServerImplStubClassName = "javax.management.remote.rmi.RMIServerImpl_Stub";
        private static final Class<? extends Remote> rmiServerImplStubClass;

        public ProxyClient(JmxModelImpl model, String hostName, int port, String userName, String password) throws IOException {
            this.model = model;
            this.displayName = this.connectionName = ProxyClient.getConnectionName(hostName, port, userName);
            if (hostName.equals("localhost") && port == 0) {
                this.hostName = hostName;
                this.port = port;
            } else {
                String urlPath = "/jndi/rmi://" + hostName + ":" + port + "/jmxrmi";
                JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
                this.setParameters(url, userName, password);
                this.vmConnector = true;
                this.registryHostName = hostName;
                this.registryPort = port;
                this.checkSslConfig();
            }
        }

        public ProxyClient(JmxModelImpl model, String url, String userName, String password) throws IOException {
            this.model = model;
            this.displayName = this.connectionName = ProxyClient.getConnectionName(url, userName);
            this.setParameters(new JMXServiceURL(url), userName, password);
        }

        public ProxyClient(JmxModelImpl model, LocalVirtualMachine lvm) throws IOException {
            this.model = model;
            this.lvm = lvm;
            this.connectionName = ProxyClient.getConnectionName(lvm);
            this.displayName = "pid: " + lvm.vmid();
        }

        private void setParameters(JMXServiceURL url, String userName, String password) {
            this.jmxUrl = url;
            if (this.jmxUrl != null) {
                this.hostName = this.jmxUrl.getHost();
                this.port = this.jmxUrl.getPort();
            }
            this.userName = userName;
            this.password = password;
        }

        private static void checkStub(Remote stub, Class<? extends Remote> stubClass) {
            RemoteRef ref;
            if (stub.getClass() != stubClass) {
                if (!Proxy.isProxyClass(stub.getClass())) {
                    throw new SecurityException("Expecting a " + stubClass.getName() + " stub!");
                }
                InvocationHandler handler = Proxy.getInvocationHandler(stub);
                if (handler.getClass() != RemoteObjectInvocationHandler.class) {
                    throw new SecurityException("Expecting a dynamic proxy instance with a " + RemoteObjectInvocationHandler.class.getName() + " invocation handler!");
                }
                stub = (Remote)((Object)handler);
            }
            if ((ref = ((RemoteObject)stub).getRef()).getClass() != UnicastRef2.class) {
                throw new SecurityException("Expecting a " + UnicastRef2.class.getName() + " remote reference in stub!");
            }
            LiveRef liveRef = ((UnicastRef2)ref).getLiveRef();
            RMIClientSocketFactory csf = liveRef.getClientSocketFactory();
            if (csf == null || csf.getClass() != SslRMIClientSocketFactory.class) {
                throw new SecurityException("Expecting a " + SslRMIClientSocketFactory.class.getName() + " RMI client socket factory in stub!");
            }
        }

        private void checkSslConfig() throws IOException {
            try {
                Registry registry = LocateRegistry.getRegistry(this.registryHostName, this.registryPort, sslRMIClientSocketFactory);
                try {
                    this.stub = (RMIServer)registry.lookup("jmxrmi");
                }
                catch (NotBoundException nbe) {
                    throw (IOException)new IOException(nbe.getMessage()).initCause(nbe);
                }
                this.sslRegistry = true;
            }
            catch (IOException e) {
                Registry registry = LocateRegistry.getRegistry(this.registryHostName, this.registryPort);
                try {
                    this.stub = (RMIServer)registry.lookup("jmxrmi");
                }
                catch (NotBoundException nbe) {
                    throw (IOException)new IOException(nbe.getMessage()).initCause(nbe);
                }
                this.sslRegistry = false;
            }
            try {
                ProxyClient.checkStub(this.stub, rmiServerImplStubClass);
                this.sslStub = true;
            }
            catch (SecurityException e) {
                this.sslStub = false;
            }
        }

        public boolean isSslRmiRegistry() {
            if (!this.isVmConnector()) {
                throw new UnsupportedOperationException("ProxyClient.isSslRmiRegistry() is only supported if this ProxyClient is a JMX connector for a JMX VM agent");
            }
            return this.sslRegistry;
        }

        public boolean isSslRmiStub() {
            if (!this.isVmConnector()) {
                throw new UnsupportedOperationException("ProxyClient.isSslRmiStub() is only supported if this ProxyClient is a JMX connector for a JMX VM agent");
            }
            return this.sslStub;
        }

        public boolean isVmConnector() {
            return this.vmConnector;
        }

        private void setConnectionState(JmxModel.ConnectionState state) {
            JmxModel.ConnectionState oldState = this.connectionState;
            this.connectionState = state;
            this.model.propertyChangeSupport.firePropertyChange("connectionState", oldState, state);
        }

        public JmxModel.ConnectionState getConnectionState() {
            return this.connectionState;
        }

        void connect() {
            block4: {
                this.setConnectionState(JmxModel.ConnectionState.CONNECTING);
                try {
                    this.tryConnect();
                    this.setConnectionState(JmxModel.ConnectionState.CONNECTED);
                }
                catch (SecurityException e) {
                    this.setConnectionState(JmxModel.ConnectionState.DISCONNECTED);
                    throw e;
                }
                catch (Exception e) {
                    this.setConnectionState(JmxModel.ConnectionState.DISCONNECTED);
                    if (e.toString().contains("com.sun.enterprise.security.LoginException")) {
                        throw new SecurityException("Authentication failed! Invalid username or password");
                    }
                    if (!LOGGER.isLoggable(Level.INFO)) break block4;
                    String param = this.lvm != null ? String.valueOf(this.lvm.vmid()) : (this.jmxUrl != null ? this.jmxUrl.toString() : "");
                    LOGGER.log(Level.INFO, "connect(" + param + ")", e);
                }
            }
        }

        private void tryConnect() throws IOException {
            if (this.jmxUrl == null && "localhost".equals(this.hostName) && this.port == 0) {
                this.jmxc = null;
                this.conn = ManagementFactory.getPlatformMBeanServer();
            } else {
                if (this.lvm != null) {
                    if (!this.lvm.isManageable()) {
                        this.lvm.startManagementAgent();
                        if (!this.lvm.isManageable()) {
                            throw new IOException(this.lvm + " not manageable");
                        }
                    }
                    if (this.jmxUrl == null) {
                        this.jmxUrl = new JMXServiceURL(this.lvm.connectorAddress());
                    }
                }
                if (this.userName == null && this.password == null) {
                    if (this.isVmConnector()) {
                        if (this.stub == null) {
                            this.checkSslConfig();
                        }
                        this.jmxc = new RMIConnector(this.stub, null);
                        this.jmxc.addConnectionNotificationListener(this, null, null);
                        this.jmxc.connect();
                    } else {
                        this.jmxc = JMXConnectorFactory.newJMXConnector(this.jmxUrl, null);
                        this.jmxc.addConnectionNotificationListener(this, null, null);
                        this.jmxc.connect();
                    }
                } else {
                    HashMap<String, String[]> env = new HashMap<String, String[]>();
                    env.put("jmx.remote.credentials", new String[]{this.userName, this.password});
                    if (this.isVmConnector()) {
                        if (this.stub == null) {
                            this.checkSslConfig();
                        }
                        this.jmxc = new RMIConnector(this.stub, null);
                        this.jmxc.addConnectionNotificationListener(this, null, null);
                        this.jmxc.connect(env);
                    } else {
                        this.jmxc = JMXConnectorFactory.newJMXConnector(this.jmxUrl, env);
                        this.jmxc.addConnectionNotificationListener(this, null, null);
                        this.jmxc.connect(env);
                    }
                }
                MBeanServerConnection mbsc = this.jmxc.getMBeanServerConnection();
                this.conn = Checker.newChecker(this, mbsc);
            }
            this.isDead = false;
        }

        public static String getConnectionName(LocalVirtualMachine lvm) {
            return Integer.toString(lvm.vmid());
        }

        public static String getConnectionName(String url, String userName) {
            if (userName != null && userName.length() > 0) {
                return userName + "@" + url;
            }
            return url;
        }

        public static String getConnectionName(String hostName, int port, String userName) {
            String name = hostName + ":" + port;
            if (userName != null && userName.length() > 0) {
                return userName + "@" + name;
            }
            return name;
        }

        public String connectionName() {
            return this.connectionName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.displayName;
        }

        public MBeanServerConnection getMBeanServerConnection() {
            return this.conn;
        }

        public JMXServiceURL getUrl() {
            return this.jmxUrl;
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }

        public int getVmid() {
            return this.lvm != null ? this.lvm.vmid() : 0;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void disconnect() {
            this.disconnectImpl(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void disconnectImpl(boolean sendClose) {
            this.stub = null;
            if (this.jmxc != null) {
                try {
                    if (sendClose) {
                        this.jmxc.close();
                    }
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        this.jmxc.removeConnectionNotificationListener(this);
                    }
                    catch (Exception e) {}
                }
            }
            if (!this.isDead) {
                this.isDead = true;
                this.setConnectionState(JmxModel.ConnectionState.DISCONNECTED);
            }
        }

        public synchronized void markAsDead() {
            this.disconnect();
        }

        public boolean isDead() {
            return this.isDead;
        }

        boolean isConnected() {
            return !this.isDead();
        }

        @Override
        public void handleNotification(Notification n, Object hb) {
            if (n instanceof JMXConnectionNotification && ("jmx.remote.connection.failed".equals(n.getType()) || "jmx.remote.connection.closed".equals(n.getType()))) {
                this.markAsDead();
            }
        }

        static {
            Class<Remote> serverStubClass = null;
            try {
                serverStubClass = Class.forName(rmiServerImplStubClassName).asSubclass(Remote.class);
            }
            catch (ClassNotFoundException e) {
                throw (InternalError)new InternalError(e.getMessage()).initCause(e);
            }
            rmiServerImplStubClass = serverStubClass;
        }
    }

    class ApplicationAvailabilityListener
    implements PropertyChangeListener {
        ApplicationAvailabilityListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getNewValue().equals(1)) {
                ((Application)evt.getSource()).removePropertyChangeListener("prop_state", (PropertyChangeListener)this);
                JmxModelImpl.this.client.disconnectImpl(false);
                JmxModelImpl.this.availabilityListener = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ApplicationRemovedListener
    implements DataRemovedListener<Application> {
        ApplicationRemovedListener() {
        }

        public void dataRemoved(Application application) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    JmxModelImpl.this.client.markAsDead();
                    JmxModelImpl.this.removedListener = null;
                }
            });
        }
    }
}

