using System;
using System.Collections.Generic;
using System.Text;

namespace EntityManagement.BusinessInterface
{
    public interface IEntityManagement
    {
        // funcionalidades bsicas
        int AddPerson(PersonData p);
        int AddOrganization(OrganizationData o);
        EntityData GetEntity(int key);
        IList<PersonData> GetPersons(string nameFilter);
        IList<OrganizationData> GetOrganizations(string nameFilter);
        int AddAddress(AddressData a, int? keyToEntity);
        AddressData GetAddress(int key);
        IList<AddressData> GetAddressesForEntity(int keyEntity);
        void AttachAddressToEntity(int keyAddress, int keyEntity, bool isPrimary);

        //// pontos de contactos
        //int AttachContactPointToEntity(int keyEntity, ContactPoint c, ContactPreference pref);
        //int SetContactPreference(int keyEntity, int keyContactPoint, ContactPreference pref);
        //IList<ContactPoint> GetContactPointsForEntity(int keyEntity);
        //IList<ContactPoint> GetContactPointsAccordingToPreference(int keyEntity, DayOfWeek p1, TimeOfDay p2);

        // outras funcionalidades
        EntityData GetEntity(string nif);
        IList<EntityData> GetEntities(string nameFilter);
        IList<AddressData> GetAddresses(string streetFilter, string localFilter);
        void SetPrimaryAddress(int keyEntity, int keyAddress);		
    }
}
