using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using OpenGL;

namespace Demo2
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            openGLPanel1.Draw += new OpenGL.DrawHandler(openGLPanel1_Draw);
        }

        float red=1.0f, green=1.0f, blue=1.0f;
        double deltaCube = 0.0;
        double deltaTriang = 0.0;
        string mensagem="Hello from OpenGL";

        void openGLPanel1_Draw()
        {
            GL.glClearColor(red, green, blue, 0);
            GL.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
            GL.glLoadIdentity();

            GL.glTranslatef(0.0f, 2.0f, -6.0f);						// Translate 6 Units Into The Screen

            GL.glColor3f(0.0f, 0.0f, 0.0f);
            //foreach (char c in mensagem)
            //    GLUT.glutBitmapCharacter(GLUT.GLUT_BITMAP_TIMES_ROMAN_10, (int)c);
            //GLUT.glutBitmapCharacter(4, (int)'A');

            //GL.glPushMatrix();
            //GL.glRotatef(90, 0.0f, 0.0f, 1.0f);
            //GL.glTranslatef(-750, 0, 0);
            //foreach (char c in mensagem)
            //{
            //    GLUT.glutStrokeCharacter(GLUT.GLUT_BITMAP_TIMES_ROMAN_10, (int)c);
            //}
            //GL.glPopMatrix();


            GL.glTranslatef(0.0f, -2.0f, 0.0f);

            GL.glPushMatrix();
                GL.glRotated(deltaTriang, 0.0, 1.0, 0.0);
                // Begin Drawing Triangles
                GL.glBegin(GL.GL_TRIANGLES);						
                    GL.glColor3f(1.0f, 0.0f, 0.0f); 
                    GL.glVertex3f(0.0f, 1.0f, 0.0f);
                    GL.glColor3f(0.0f, 1.0f, 0.0f); 
                    GL.glVertex3f(-1.0f, -1.0f, 1.0f);
                    GL.glColor3f(0.0f, 0.0f, 1.0f); 
                    GL.glVertex3f(1.0f, -1.0f, 1.0f);
                GL.glEnd();
                // Done Drawing Triangles
            GL.glPopMatrix();

            GL.glTranslatef(2.0f, 2.0f, 0.0f);	

            GL.glPushMatrix();
                GL.glRotated(deltaCube, 1.0, 0.0, 0.0);
                GL.glColor3d(1.0, 0.0, 0.0);
                GLUT.glutSolidCube(1);  // show binding with GLUT
                GL.glColor3d(0.0, 1.0, 0.0);
                GLUT.glutWireCube(1);   // show binding with GLUT
            GL.glPopMatrix();

            GL.glFlush();
        }

        private void BackgroundColorRed()
        {
            red = 1.0f;
            green = 0.0f;
            blue = 0.0f;

            // force redraw
            openGLPanel1.Invalidate();
        }

        private void BackgroundColorBlue()
        {
            red = 0.0f;
            green = 0.0f;
            blue = 1.0f;

            // force redraw
            openGLPanel1.Invalidate();
        }

        private void BackgroundColorGreen()
        {
            red = 0.0f;
            green = 1.0f;
            blue = 0.0f;

            // force redraw
            openGLPanel1.Invalidate();
        }

        private void BackgroundColorWhite()
        {
            red = 1.0f;
            green = 1.0f;
            blue = 1.0f;

            // force redraw
            openGLPanel1.Invalidate();
        }

        private void BackgroundColorBlack()
        {
            red = 0.0f;
            green = 0.0f;
            blue = 0.0f;

            // force redraw
            openGLPanel1.Invalidate();
        }


        private void BackgroundWhite()
        {
            red = 1.0f;
            green = 1.0f;
            blue = 1.0f;

            // force redraw
            openGLPanel1.Invalidate();
        }

        private void BackgroundBlack()
        {
            red = 0.0f;
            green = 0.0f;
            blue = 0.0f;

            // force redraw
            openGLPanel1.Invalidate();
        }

        private void timerTriang_Tick(object sender, EventArgs e)
        {
            deltaTriang += 5.0;

            // force redraw
            openGLPanel1.Invalidate();
        }

        private void timerCube_Tick(object sender, EventArgs e)
        {
            deltaCube -= 5.0;

            // force redraw
            openGLPanel1.Invalidate();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void onOffToolStripMenuItem_Click(object sender, EventArgs e)
        {
            timerCube.Enabled = !timerCube.Enabled;
            timerTriang.Enabled = !timerTriang.Enabled;
        }

        private void btnChangeMsg_Click(object sender, EventArgs e)
        {
            mensagem = textBox1.Text;

            openGLPanel1.Invalidate();
        }

        private void cbBackgroundColor_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch ((string)cbBackgroundColor.SelectedItem)
            {
                case "Red":
                    BackgroundColorRed();
                    break;
                case "Green":
                    BackgroundColorGreen();
                    break;
                case "Blue":
                    BackgroundColorBlue();
                    break;
                case "White":
                    BackgroundColorWhite();
                    break;
                case "Black":
                    BackgroundColorBlack();
                    break;
            }
        }
    }
}