using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices; 

namespace OpenGL
{
    public class GLUT
    {
        private const string GLUT_DLL = "glut32";

        // Stroke font constants (use these in GLUT program). 
        //public static readonly IntPtr GLUT_STROKE_ROMAN = new IntPtr(0);
        //public static readonly IntPtr GLUT_STROKE_MONO_ROMAN = new IntPtr(1);

        // Bitmap font constants (use these in GLUT program). 
        //public static readonly IntPtr GLUT_BITMAP_9_BY_15 = new IntPtr(2);
        //public static readonly IntPtr GLUT_BITMAP_8_BY_13 = new IntPtr(3);
        //public static readonly IntPtr GLUT_BITMAP_TIMES_ROMAN_10 = new IntPtr(4);
        //public static readonly IntPtr GLUT_BITMAP_TIMES_ROMAN_24 = new IntPtr(5);
        //public static readonly IntPtr GLUT_BITMAP_HELVETICA_10 = new IntPtr(6);
        //public static readonly IntPtr GLUT_BITMAP_HELVETICA_12 = new IntPtr(7);
        //public static readonly IntPtr GLUT_BITMAP_HELVETICA_18 = new IntPtr(8);
        public const int GLUT_BITMAP_9_BY_15 = (2);
        public const int GLUT_BITMAP_8_BY_13 = (3);
        public const int GLUT_BITMAP_TIMES_ROMAN_10 = (4);
        public const int GLUT_BITMAP_TIMES_ROMAN_24 = (5);
        public const int GLUT_BITMAP_HELVETICA_10 = (6);
        public const int GLUT_BITMAP_HELVETICA_12 = (7);
        public const int GLUT_BITMAP_HELVETICA_18 = (8);

        /* GLUT pre-built models sub-API */
        [DllImport(GLUT_DLL, EntryPoint ="glutSolidCone")]
        public static extern void glutSolidCone(double xbase, double height, int slices, int stacks);        	
        [DllImport(GLUT_DLL, EntryPoint ="glutSolidCube")]
        public static extern void glutSolidCube(double size);	
        [DllImport(GLUT_DLL, EntryPoint ="glutSolidDodecahedron")]
        public static extern void glutSolidDodecahedron();	
        [DllImport(GLUT_DLL, EntryPoint ="glutSolidIcosahedron")]
        public static extern void glutSolidIcosahedron();
        [DllImport(GLUT_DLL, EntryPoint ="glutSolidOctahedron")]
        public static extern void glutSolidOctahedron();	
        [DllImport(GLUT_DLL, EntryPoint ="glutSolidSphere")]
        public static extern void glutSolidSphere(double radius, int slices, int stacks);
        [DllImport(GLUT_DLL, EntryPoint ="glutSolidTeapot")]
        public static extern void glutSolidTeapot(double size);
        [DllImport(GLUT_DLL, EntryPoint ="glutSolidTetrahedron")]
        public static extern void glutSolidTetrahedron();
        [DllImport(GLUT_DLL, EntryPoint ="glutSolidTorus")]
        public static extern void glutSolidTorus(double innerRadius, double outerRadius, int sides, int rings);	
        [DllImport(GLUT_DLL, EntryPoint ="glutWireCone")]
        public static extern void glutWireCone(double xbase, double height, int slices, int stacks);	
        [DllImport(GLUT_DLL, EntryPoint ="glutWireCube")]
        public static extern void glutWireCube(double size);	
        [DllImport(GLUT_DLL, EntryPoint ="glutWireDodecahedron")]
        public static extern void glutWireDodecahedron();	
        [DllImport(GLUT_DLL, EntryPoint ="glutWireIcosahedron")]
        public static extern void glutWireIcosahedron();	
        [DllImport(GLUT_DLL, EntryPoint ="glutWireOctahedron")]
        public static extern void glutWireOctahedron();	
        [DllImport(GLUT_DLL, EntryPoint ="glutWireSphere")]
        public static extern void glutWireSphere(double radius, int slices, int stacks);	
        [DllImport(GLUT_DLL, EntryPoint ="glutWireTeapot")]
        public static extern void glutWireTeapot(double size);
        [DllImport(GLUT_DLL, EntryPoint ="glutWireTetrahedron")]
        public static extern void glutWireTetrahedron();
        [DllImport(GLUT_DLL, EntryPoint ="glutWireTorus")]
        public static extern void glutWireTorus(double innerRadius, double outerRadius, int sides, int rings);

        
        // GLUT font sub-API
        [DllImport(GLUT_DLL, EntryPoint = "glutBitmapCharacter")]
        public static extern void glutBitmapCharacter(int font, int character);
        [DllImport(GLUT_DLL, EntryPoint = "glutBitmapWidth")]
        public static extern int glutBitmapWidth(int font, int character);
        [DllImport(GLUT_DLL, EntryPoint = "glutStrokeCharacter")]
        public static extern void glutStrokeCharacter(int font, int character);
        [DllImport(GLUT_DLL, EntryPoint = "glutStrokeWidth")]
        public static extern int glutStrokeWidth(int font, int character);
        

        /*
// GLUT state retrieval sub-API.
public static extern int glutGet(GLenum type);
public static extern int glutDeviceGet(GLenum type);
// GLUT extension support sub-API
public static extern int  glutExtensionSupported(char *name);
public static extern int  glutGetModifiers();
public static extern int  glutLayerGet(GLenum type);
        
        */

        
    }
}
