using System;
using System.Collections.Generic;
using System.Text;

namespace OpenGL
{
    public delegate void DrawHandler();

    public class OpenGLPanel : BaseGLControl
    {
        /// <summary> 
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public OpenGLPanel() : base()
        {
            // This call is required by the Windows.Forms Form Designer.
            InitializeComponent();

            this.Draw += new DrawHandler(DefaultDraw);
        }

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

        #region Component Designer generated code
        /// <summary> 
        /// Required method for Designer support - do not modify 
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();
        }
        #endregion


        public event DrawHandler Draw;

        //public OpenGL.GL GL
        //{
        //    get
        //    {
        //        return OpenGL.GL;
        //    }
        //}

        private void DefaultDraw()
        {
            ////Just clear the screen
            GL.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
            GL.glLoadIdentity();
            GL.glFlush();
        }

        // do not override; use Draw() instead
        protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
        {
            if (m_uint_DC == 0 || m_uint_RC == 0)
                return;
            
            WGL.wglMakeCurrent(m_uint_DC, m_uint_RC);

            if (Draw != null)
                Draw();

            WGL.wglSwapBuffers(m_uint_DC);
        }
    }
}
